/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitProperties;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;

@OnlyIn(value=Dist.CLIENT)
public class ItemModel {
    public static final String INVENTORY = "inventory";

    public static ModelResourceLocation getInventoryLoc(Item item) {
        return new ModelResourceLocation(item.getRegistryName(), INVENTORY);
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        protected final ForgeMod mod;

        public static Properties<?> of(ForgeMod mod) {
            return new Properties<Properties>(mod, Properties.class);
        }

        protected Properties(ForgeMod mod, Class<T> selfClass) {
            super(selfClass);
            this.mod = mod;
        }

        public T register(Item item, String name, IPropertyGetter getter) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)this.mod.getNamespace().location(name), (IItemPropertyGetter)getter);
            return (T)((Properties)this.self);
        }

        public static interface IPropertyGetter
        extends IItemPropertyGetter {
            @Deprecated
            default public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity living) {
                return this.get(stack, Optional.ofNullable(world), Optional.ofNullable(living));
            }

            public float get(ItemStack var1, Optional<ClientWorld> var2, Optional<LivingEntity> var3);
        }
    }

    public static class RegistryWrapper {
        protected final Map<ResourceLocation, IBakedModel> registry;

        public RegistryWrapper(Map<ResourceLocation, IBakedModel> registry) {
            this.registry = registry;
        }

        @Nullable
        public IBakedModel getModelOf(Item item) {
            ModelResourceLocation loc = ItemModel.getInventoryLoc(item);
            return this.registry.get(loc);
        }

        @Nullable
        public IBakedModel getModelOf(BlockState state) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            return this.registry.get(location);
        }

        public boolean replaceModelOf(Item item, IBakedModel newModel) {
            ModelResourceLocation loc = ItemModel.getInventoryLoc(item);
            return this.registry.put((ResourceLocation)loc, newModel) != null;
        }

        public boolean replaceModelOf(Item item, IModelWrapperFactory<?> newModelFactory) {
            IBakedModel original = this.getModelOf(item);
            if (original != null) {
                return this.replaceModelOf(item, (IBakedModel)newModelFactory.create(original));
            }
            ForgeEndertech.getInstance().getLogger().error("Unable to find and replace item model for " + item.toString());
            return false;
        }

        public boolean replaceModelOf(BlockState state, IBakedModel newModel) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            return this.registry.put((ResourceLocation)location, newModel) != null;
        }

        public boolean replaceModelOf(BlockState state, IModelWrapperFactory<?> newModelFactory) {
            IBakedModel original = this.getModelOf(state);
            if (original != null) {
                return this.replaceModelOf(state, (IBakedModel)newModelFactory.create(original));
            }
            ForgeEndertech.getInstance().getLogger().error("Unable to find and replace block model for " + state.toString());
            return false;
        }
    }

    public static interface IModelWrapperFactory<T extends IBakedModel> {
        public BakedModelWrapper<T> create(IBakedModel var1);
    }

    public static class Combined
    implements IBakedModel {
        protected final IBakedModel baseModel;
        protected final IBakedModel[] additionalModels;

        public Combined(IBakedModel baseModel, IBakedModel ... additionalModels) {
            this.baseModel = baseModel;
            this.additionalModels = additionalModels;
        }

        public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
            ImmutableList.Builder quads = ImmutableList.builder();
            quads.addAll((Iterable)this.baseModel.func_200117_a(state, side, rand));
            for (IBakedModel additional : this.additionalModels) {
                quads.addAll((Iterable)additional.func_200117_a(state, side, rand));
            }
            return quads.build();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean func_177555_b() {
            return this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.baseModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.baseModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.baseModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.baseModel.func_177552_f();
        }

        public boolean func_230044_c_() {
            return false;
        }
    }

    public static class BuiltIn
    extends BakedModelWrapper<IBakedModel> {
        protected ItemOverrideList overrides = null;
        protected Map<IBakedModel, BuiltIn> builtInForModel = null;

        public BuiltIn(IBakedModel originalModel) {
            super(originalModel);
        }

        public boolean func_188618_c() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            super.handlePerspective(cameraTransformType, mat);
            return this;
        }

        public ItemOverrideList func_188617_f() {
            if (this.overrides == null) {
                this.overrides = new ItemOverrideList(){

                    @Nullable
                    public IBakedModel func_239290_a_(IBakedModel modelIn, ItemStack stackIn, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
                        BuiltIn builtIn;
                        IBakedModel model = originalModel.func_188617_f().func_239290_a_(modelIn, stackIn, worldIn, entityIn);
                        if (model.func_188618_c()) {
                            return model;
                        }
                        if (builtInForModel == null) {
                            builtInForModel = new ConcurrentHashMap<IBakedModel, BuiltIn>();
                        }
                        if ((builtIn = builtInForModel.get(model)) == null) {
                            builtIn = new BuiltIn(model);
                            builtInForModel.put(model, builtIn);
                        }
                        return builtIn;
                    }

                    public ImmutableList<ItemOverride> getOverrides() {
                        return originalModel.func_188617_f().getOverrides();
                    }
                };
            }
            return this.overrides;
        }
    }

    public static abstract class Replacer<T extends IBakedModel>
    extends BakedModelWrapper<T> {
        protected final ItemOverrideList overrides = new ItemOverrideList(){

            @Nullable
            public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity living) {
                return this.chooseModelFor(stack, (World)world, living);
            }
        };

        public Replacer(T originalModel) {
            super(originalModel);
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            super.handlePerspective(cameraTransformType, mat);
            return this;
        }

        public abstract IBakedModel chooseModelFor(ItemStack var1, @Nullable World var2, @Nullable LivingEntity var3);

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }
}

