/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ChameleonBlockModel
extends BakedModelWrapper<IBakedModel> {
    protected final Map<BlockState, SimpleBakedModel> retexturedModels = new ConcurrentHashMap<BlockState, SimpleBakedModel>();

    public ChameleonBlockModel(IBakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        BlockState targetBlock = this.getTargetBlock(extraData).orElse(null);
        if (targetBlock == null || targetBlock == state || targetBlock.func_196958_f()) {
            return this.originalModel.getQuads(state, side, rand, extraData);
        }
        IBakedModel retexturedModel = (IBakedModel)this.retexturedModels.computeIfAbsent(targetBlock, key -> {
            IBakedModel targetModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(targetBlock);
            TextureAtlasSprite oldTexture = this.originalModel.getParticleTexture(extraData);
            TextureAtlasSprite newTexture = targetModel != this ? targetModel.getParticleTexture(extraData) : oldTexture;
            return this.createRetexturedModel(state, rand, oldTexture, newTexture);
        });
        return retexturedModel.getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.getTargetBlock(data).map(this.retexturedModels::get).map(model -> model.getParticleTexture(data)).orElseGet(() -> this.originalModel.getParticleTexture(data));
    }

    protected Optional<BlockState> getTargetBlock(IModelData data) {
        return data.hasProperty(Data.BLOCK_STATE) ? Optional.ofNullable((BlockState)data.getData(Data.BLOCK_STATE)) : Optional.empty();
    }

    protected SimpleBakedModel createRetexturedModel(@Nullable BlockState state, Random rand, TextureAtlasSprite oldTexture, TextureAtlasSprite newTexture) {
        List unculledFaces = this.originalModel.getQuads(state, null, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture)).collect(Collectors.toList());
        EnumMap culledFaces = new EnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            culledFaces.put(direction, this.originalModel.getQuads(state, direction, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture)).collect(Collectors.toList()));
        }
        return new SimpleBakedModel(unculledFaces, culledFaces, this.originalModel.func_177555_b(), this.originalModel.func_230044_c_(), this.originalModel.func_177556_c(), newTexture, this.originalModel.func_177552_f(), this.originalModel.func_188617_f());
    }

    protected BakedQuad retextureQuad(BakedQuad quad, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite) {
        if (!oldSprite.equals(newSprite) && quad.func_187508_a().equals(oldSprite)) {
            int[] updatedVerticies = this.updateVertices(quad.func_178209_a(), quad.func_187508_a(), newSprite);
            return new BakedQuad(updatedVerticies, quad.func_178211_c(), quad.func_178210_d(), newSprite, quad.func_239287_f_());
        }
        return quad;
    }

    protected int[] updateVertices(int[] vertices, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite) {
        int[] updatedVertices = (int[])vertices.clone();
        VertexFormat blockFormat = DefaultVertexFormats.field_176600_a;
        for (int i = 0; i < blockFormat.func_177338_f(); i += blockFormat.func_181719_f()) {
            double u = this.getUV(Float.intBitsToFloat(vertices[i + 4]), oldSprite.func_94209_e(), oldSprite.func_94212_f());
            double v = this.getUV(Float.intBitsToFloat(vertices[i + 5]), oldSprite.func_94206_g(), oldSprite.func_94210_h());
            updatedVertices[i + 4] = Float.floatToRawIntBits(newSprite.func_94214_a(u));
            updatedVertices[i + 5] = Float.floatToRawIntBits(newSprite.func_94207_b(v));
        }
        return updatedVertices;
    }

    protected double getUV(float uv, float uv0, float uv1) {
        return (double)(uv - uv0) * 16.0 / (double)(uv1 - uv0);
    }

    public static class Data
    implements IModelData {
        public static final ModelProperty<BlockState> BLOCK_STATE = new ModelProperty();
        protected BlockState blockState;

        public Data(BlockState blockState) {
            this.blockState = blockState;
        }

        public boolean hasProperty(ModelProperty<?> prop) {
            return prop == BLOCK_STATE;
        }

        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            return (T)(this.hasProperty(prop) ? this.blockState : null);
        }

        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            if (this.hasProperty(prop)) {
                this.blockState = (BlockState)data;
                return data;
            }
            return null;
        }
    }
}

