/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public interface ISmokeContainer {
    public ColorARGB getColor();

    public Type getType();

    default public boolean is(Type type) {
        return this.getType() == type;
    }

    default public boolean isChimney() {
        return this.is(Type.CHIMNEY);
    }

    default public boolean isVent() {
        return this.is(Type.VENT);
    }

    default public boolean isPump() {
        return this.is(Type.PUMP);
    }

    default public boolean isPipe() {
        return this.is(Type.PIPE);
    }

    public boolean isActive(IBlockReader var1, BlockPos var2);

    default public List<BlockPos> getClosestActiveExhaustPumps(IWorld level, BlockPos pos) {
        return Collections.emptyList();
    }

    public static enum Type implements IForgeEnum
    {
        CHIMNEY,
        VENT,
        PUMP,
        PIPE;

    }
}

