/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;

public interface IPole
extends IWaterLoggable {
    public static boolean isEmptyPlace(IWorldReader level, BlockPos pos) {
        return !World.func_189509_E((BlockPos)pos) && level.func_175667_e(pos) && (GameWorld.isAirBlock(level, pos) || GameWorld.isWaterBlock(level, pos));
    }

    public static boolean replaceWith(BlockState state, ServerWorld level, BlockPos pos) {
        BlockState oldState = level.func_180495_p(pos);
        BlockState newState = IWaterLoggable.getStateForPlacementAt((IWorldReader)level, pos, state);
        return newState == oldState || level.func_175656_a(pos, newState);
    }

    public boolean isApex(BlockState var1);

    public boolean isPole(BlockState var1);

    default public boolean isApex(IWorldReader level, BlockPos pos) {
        return level.func_175667_e(pos) && this.isApex(level.func_180495_p(pos));
    }

    default public boolean isPole(IWorldReader level, BlockPos pos) {
        return level.func_175667_e(pos) && this.isPole(level.func_180495_p(pos));
    }

    default public boolean canBuildUp(World level, BlockPos startPos) {
        BlockPos top = this.getTop((IWorldReader)level, startPos).func_177984_a();
        if (this.isApex((IWorldReader)level, top)) {
            top = top.func_177984_a();
        }
        return IPole.isEmptyPlace((IWorldReader)level, top);
    }

    default public boolean canStayAt(IWorldReader level, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        if (this.isPole(level, down) || Block.func_220055_a((IWorldReader)level, (BlockPos)down, (Direction)Direction.UP)) {
            return true;
        }
        BlockPos up = pos.func_177984_a();
        return this.isPole(level, up) || Block.func_220055_a((IWorldReader)level, (BlockPos)up, (Direction)Direction.DOWN);
    }

    default public BlockPos getTop(IWorldReader level, BlockPos startPos) {
        return GameWorld.Positions.getLastInLine(level, startPos, this::isPole, Direction.UP);
    }

    default public BlockPos getBottom(IWorldReader level, BlockPos startPos) {
        return GameWorld.Positions.getLastInLine(level, startPos, this::isPole, Direction.DOWN);
    }

    default public int buildUp(ServerWorld level, BlockPos from, BlockState poleToAdd, int quantity) {
        int i;
        if (!this.isPole((IWorldReader)level, from)) {
            return 0;
        }
        BlockPos top = this.getTop((IWorldReader)level, from);
        Optional<Apex> apex = this.isApex((IWorldReader)level, top.func_177984_a()) ? Optional.of(new Apex((World)level, top.func_177984_a())) : Optional.empty();
        int empty = 0;
        int n = i = apex.isPresent() ? 2 : 1;
        while (empty < quantity && IPole.isEmptyPlace((IWorldReader)level, top.func_177981_b(i))) {
            ++empty;
            ++i;
        }
        if ((quantity = Math.min(quantity, empty)) < 1) {
            return 0;
        }
        apex.ifPresent(Apex::removeBlock);
        for (int y = top.func_177956_o(); y >= from.func_177956_o(); --y) {
            BlockPos source = GameWorld.Positions.withY(from, y);
            BlockPos dest = source.func_177981_b(quantity);
            BlockState poleToMove = level.func_180495_p(source);
            if (IWaterLoggable.isWaterlogged(poleToMove)) {
                poleToMove = (BlockState)poleToMove.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            IPole.replaceWith(poleToMove, level, dest);
        }
        int added = 0;
        for (int i2 = 0; i2 < quantity; ++i2) {
            if (!IPole.replaceWith(poleToAdd, level, from.func_177981_b(i2))) continue;
            ++added;
        }
        if (apex.isPresent()) {
            ((Apex)apex.get()).restoreAt((World)level, ((Apex)apex.get()).getPos().func_177981_b(quantity));
        }
        return added;
    }

    default public int breakDown(ServerWorld level, BlockPos from, int quantity, boolean dropItems) {
        int i;
        if (!this.isPole((IWorldReader)level, from)) {
            return 0;
        }
        BlockPos top = this.getTop((IWorldReader)level, from);
        int poleLength = top.func_177956_o() - from.func_177956_o() + 1;
        quantity = Math.min(quantity, poleLength);
        Optional<Apex> apex = this.isApex((IWorldReader)level, top.func_177984_a()) ? Optional.of(new Apex((World)level, top.func_177984_a())) : Optional.empty();
        apex.ifPresent(Apex::removeBlock);
        int broken = 0;
        for (i = 0; i < quantity; ++i) {
            if (!level.func_175655_b(from.func_177981_b(i), dropItems)) continue;
            ++broken;
        }
        if (quantity < poleLength) {
            for (int y = from.func_177956_o(); y <= top.func_177956_o(); ++y) {
                BlockPos dest = GameWorld.Positions.withY(from, y);
                BlockPos source = dest.func_177981_b(quantity);
                BlockState placement = level.func_180495_p(source);
                if (placement.func_235901_b_((Property)WATERLOGGED) && IWaterLoggable.isWaterlogged(level.func_180495_p(dest))) {
                    placement = (BlockState)placement.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                IPole.replaceWith(placement, level, dest);
            }
        }
        for (i = 0; i < quantity; ++i) {
            level.func_217377_a(top.func_177979_c(i), false);
        }
        if (apex.isPresent()) {
            ((Apex)apex.get()).restoreAt((World)level, ((Apex)apex.get()).getPos().func_177979_c(quantity));
        }
        return broken;
    }

    default public void playPlaceSound(World level, BlockPos pos, BlockState state, PlayerEntity player) {
        SoundType sound = state.getSoundType((IWorldReader)level, pos, (Entity)player);
        level.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
    }

    default public ActionResultType buildBy(PlayerEntity player, World level, BlockPos pos, Hand hand, BlockRayTraceResult hit, int quantity) {
        Block heldBlock;
        BlockState heldState;
        if (hit.func_216354_b().func_176740_k().func_200128_b()) {
            return ActionResultType.PASS;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        ItemUseContext context = new ItemUseContext(player, hand, hit);
        if (!player.func_184812_l_()) {
            quantity = Math.min(quantity, heldStack.func_190916_E());
        }
        if ((heldState = (heldBlock = Block.func_149634_a((Item)heldStack.func_77973_b())).func_196258_a(new BlockItemUseContext(context))) == null || !this.isPole(heldState)) {
            return ActionResultType.PASS;
        }
        if (level instanceof ServerWorld) {
            int built = this.buildUp((ServerWorld)level, pos, heldState, quantity);
            if (built > 0) {
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(built);
                }
                this.playPlaceSound(level, pos, heldState, player);
                return ActionResultType.SUCCESS;
            }
        } else if (this.canBuildUp(level, pos)) {
            this.playPlaceSound(level, pos, heldState, player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    default public void breakBy(PlayerEntity player, ServerWorld level, BlockPos pos, int quantity) {
        boolean dropItems = !player.func_184812_l_() && !player.func_175149_v();
        this.breakDown(level, pos, quantity, dropItems);
    }

    public static class Apex {
        private final World level;
        protected final BlockSnapshot snapshot;

        public Apex(World level, BlockPos pos) {
            this.level = level;
            this.snapshot = BlockSnapshot.create((RegistryKey)level.func_234923_W_(), (IWorld)level, (BlockPos)pos);
        }

        public World getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.snapshot.getPos();
        }

        public void removeBlock() {
            this.getLevel().func_175713_t(this.getPos());
            this.getLevel().func_217377_a(this.getPos(), false);
        }

        public boolean restoreAt(World world, BlockPos pos) {
            CompoundNBT compound = this.snapshot.getNbt();
            if (compound != null) {
                compound.func_74768_a("x", pos.func_177958_n());
                compound.func_74768_a("y", pos.func_177956_o());
                compound.func_74768_a("z", pos.func_177952_p());
            }
            return this.snapshot.restoreToLocation((IWorld)world, pos, true, true);
        }
    }
}

