/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.Dependencies;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.network.MotionController;
import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.endertech.minecraft.forge.network.UpdateBlockMsg;
import com.endertech.minecraft.forge.network.UsingItemMsg;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.Wind;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.SystemUtils;

@Mod(value="forgeendertech")
public class ForgeEndertech
extends ForgeMod {
    public static final String ID = "forgeendertech";
    public static final String NAME = "Forge Endertech";
    public static final boolean DEVELOPER_ENVIRONMENT = ASMAPI.mapField((String)"field_150244_g").equals("obfuscated") && "forgeendertech".indexOf(SystemUtils.getUserHome().getName().toLowerCase()) == 5;
    private static ForgeEndertech instance;
    static ForgeConfigSpec.ConfigValue<Boolean> debug;

    public ForgeEndertech() {
        instance = this;
        UnitConfig config = UnitConfig.in(this.getConfigsDir(), "Wind");
        Wind.randomSeed = config.getInt("Wind", "randomSeed", CommonMath.Random.getInt(), IntBounds.INTEGER, "Random seed");
        Wind.defaultWind = new Wind(config, BiomeId.EMPTY, 0.1f, 0.01f, 0.0015f);
    }

    public static ForgeEndertech getInstance() {
        return instance;
    }

    public static boolean isDebugMode() {
        return (Boolean)debug.get();
    }

    public static void debugMsg(String msg) {
        if (ForgeEndertech.isDebugMode()) {
            ForgeEndertech.getInstance().getLogger().debug(msg);
        }
    }

    public static void developMsg(String msg) {
        if (DEVELOPER_ENVIRONMENT) {
            ForgeEndertech.debugMsg(msg);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public ForgeMod.RequiredSide getRequiredSide() {
        return ForgeMod.RequiredSide.SERVER;
    }

    @Override
    public void commonInit() {
        GameWorld.isWeather2Loaded = ForgeEndertech.isLoaded("weather2");
        this.registerNetMessage(MotionController.MotionMsg::new);
        this.registerNetMessage(UsingItemMsg::new);
        this.registerNetMessage(UpdateBlockMsg::new);
        this.registerNetMessage(TileSharedDataMsg::new);
        this.registerNetMessage(Wind.WindMsg::new);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        Dependencies.checkIntegrityOnce();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
        GlassMeterRenderer.RENDER_TYPE = RenderType.func_228644_e_((ResourceLocation)GameRendering.EMPTY_TEXTURE);
    }

    @Override
    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
        value.push("SmokeContainers");
        GameWorld.SmokeContainers.maxVentPipeLength = value.comment("Maximum length of the vent pipe for smoke or gas transmition").defineInRange("maxVentPipeLength", 32, IntBounds.from(1, 64));
        GameWorld.SmokeContainers.ventReachDistance = value.comment("Maximum distance from vent to the gas block to be sucked in").defineInRange("ventReachDistance", 4, IntBounds.from(1, 16));
        GameWorld.SmokeContainers.maxBlocksInMultiblock = value.comment("Maximum amount of blocks that will be checked when searching for multiblock boundaries.").defineInRange("maxBlocksInMultiblock", 81, IntBounds.from(1, 512));
        GameWorld.SmokeContainers.pumpedChimneyAirflow = value.comment("Strength of the airflow created in the chimney by a connected exhaust pump").defineInRange("pumpedChimneyAirflow", 1, IntBounds.from(0, 10));
        GameWorld.SmokeContainers.suctionHoppersList = value.comment("List of hoppers in the following format: blockID, suctionRange\nWhere suctionRange is the radius of the cylindrical area above the hopper within which the pollution will be sucked in.\nThe height of this area is always 3 blocks.\nRange: 1 ~ 64").defineList("suctionHoppers", new String[]{"minecraft:hopper, 8", "brickhopper:brick_hopper, 6", "goldenhopper:golden_hopper, 12", "littlelogistics:rapid_hopper, 12"}, str -> {
            try {
                String[] split = str.split(",");
                if (UnitId.from(split[0].trim()).isEmpty()) {
                    return false;
                }
                int range = Integer.parseInt(split[1].trim());
                if (!IntBounds.from(1, 64).encloses(range)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        });
        value.pop();
        debug = value.comment("Enable/Disable debug mode").define("debug", false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    @Override
    public void updateReloadedTags() {
        GameWorld.SmokeContainers.suctionHoppers = BlockStatesMap.parseIntegers(((List)GameWorld.SmokeContainers.suctionHoppersList.get()).toArray(new String[0]));
        super.updateReloadedTags();
    }

    @Override
    public void commonPostInit() {
        super.commonPostInit();
    }

    @Override
    public void registerArgumentTypes() {
        ArgumentTypes.func_218136_a((String)this.getNamespace().resolve("int_bounds"), ServerCommand.IntBoundsArgument.class, (IArgumentSerializer)new ArgumentSerializer(ServerCommand.IntBoundsArgument::integer));
        ArgumentTypes.func_218136_a((String)this.getNamespace().resolve("float_bounds"), ServerCommand.FloatBoundsArgument.class, (IArgumentSerializer)new ArgumentSerializer(ServerCommand.FloatBoundsArgument::unbounded));
        ArgumentTypes.func_218136_a((String)this.getNamespace().resolve("color_argb"), ServerCommand.ColorARGBArgument.class, (IArgumentSerializer)new ArgumentSerializer(ServerCommand.ColorARGBArgument::new));
    }
}

