/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.mysticalagriculture.item.WateringCanItem;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceWateringCanItem
extends WateringCanItem {
    private final TextFormatting textColor;

    public EssenceWateringCanItem(int range, double chance, TextFormatting textColor, Function<Item.Properties, Item.Properties> properties) {
        super(range, chance, properties.compose(p -> p.func_200917_a(1)));
        this.textColor = textColor;
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)false);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Active", (boolean)false);
            items.add((Object)stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        PlayerEntity player;
        BlockRayTraceResult result;
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Active") && entity instanceof PlayerEntity && (result = EssenceWateringCanItem.func_219968_a((World)world, (PlayerEntity)(player = (PlayerEntity)entity), (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)).func_216346_c() != RayTraceResult.Type.MISS) {
            this.doWater(stack, world, player, result.func_216350_a(), result.func_216354_b());
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Active");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockState state;
        ItemStack stack = player.func_184586_b(hand);
        BlockRayTraceResult trace = EssenceWateringCanItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water") && player.func_213453_ef()) {
                NBTHelper.flipBoolean((ItemStack)stack, (String)"Active");
            }
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BlockPos pos = trace.func_216350_a();
        Direction direction = trace.func_216354_b();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos.func_177972_a(direction), direction, stack) && (state = world.func_180495_p(pos)).func_185904_a() == Material.field_151586_h) {
            NBTHelper.setString((ItemStack)stack, (String)"ID", (String)UUID.randomUUID().toString());
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)true);
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @Override
    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Active")) {
            return ActionResultType.PASS;
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        String rangeString = String.valueOf(this.range);
        IFormattableTextComponent rangeNumber = new StringTextComponent(rangeString + "x" + rangeString).func_240699_a_(this.textColor);
        tooltip.add((ITextComponent)ModTooltips.WATERING_CAN_AREA.args(new Object[]{rangeNumber}).build());
    }
}

