/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.crafting.ingredient.FilledSoulJarIngredient;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoulJarEmptyRecipe
extends ShapelessRecipe {
    public SoulJarEmptyRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        boolean hasJar = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (hasJar && !stack.func_190926_b()) {
                return false;
            }
            Item item = stack.func_77973_b();
            if (item instanceof SoulJarItem) {
                double souls = MobSoulUtils.getSouls(stack);
                if (!(souls > 0.0)) continue;
                hasJar = true;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        return hasJar;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CRAFTING_SOUL_JAR_EMPTY;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SoulJarEmptyRecipe> {
        public SoulJarEmptyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList ingredients = NonNullList.func_191197_a((int)1, (Object)((Object)new FilledSoulJarIngredient()));
            return new SoulJarEmptyRecipe(recipeId, "", new ItemStack((IItemProvider)ModItems.SOUL_JAR.get()), (NonNullList<Ingredient>)ingredients);
        }

        public SoulJarEmptyRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            NonNullList ingredients = NonNullList.func_191197_a((int)1, (Object)((Object)new FilledSoulJarIngredient()));
            return new SoulJarEmptyRecipe(recipeId, "", new ItemStack((IItemProvider)ModItems.SOUL_JAR.get()), (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(PacketBuffer buffer, SoulJarEmptyRecipe recipe) {
        }
    }
}

