/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoulExtractionRecipe
implements ISpecialRecipe,
ISoulExtractionRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final IMobSoulType type;
    private final double souls;
    private final ItemStack output;

    public SoulExtractionRecipe(ResourceLocation recipeId, Ingredient input, IMobSoulType type, double souls) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{input});
        this.type = type;
        this.souls = souls;
        this.output = MobSoulUtils.getSoulJar(type, souls);
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        ItemStack stack = inventory.getStackInSlot(2);
        ItemStack jar = StackHelper.withSize((ItemStack)stack, (int)1, (boolean)false);
        MobSoulUtils.addSoulsToJar(jar, this.type, this.souls);
        return jar;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<SoulExtractionRecipe> func_199559_b() {
        return ModRecipeSerializers.SOUL_EXTRACTION;
    }

    public IRecipeType<? extends ISoulExtractionRecipe> func_222127_g() {
        return RecipeTypes.SOUL_EXTRACTION;
    }

    public boolean matches(IItemHandler inventory, int startIndex, int endIndex) {
        ItemStack input = inventory.getStackInSlot(0);
        if (!((Ingredient)this.inputs.get(0)).test(input)) {
            return false;
        }
        ItemStack output = inventory.getStackInSlot(2);
        if (!output.func_77969_a(this.output)) {
            return false;
        }
        return MobSoulUtils.canAddTypeToJar(output, this.type) && !MobSoulUtils.isJarFull(output);
    }

    @Override
    public IMobSoulType getMobSoulType() {
        return this.type;
    }

    @Override
    public double getSouls() {
        return this.souls;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SoulExtractionRecipe> {
        public SoulExtractionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject ingredient = json.getAsJsonObject("input");
            Ingredient input = Ingredient.func_199802_a((JsonElement)ingredient);
            JsonObject output = JSONUtils.func_152754_s((JsonObject)json, (String)"output");
            String type = JSONUtils.func_151200_h((JsonObject)output, (String)"type");
            float amount = JSONUtils.func_151217_k((JsonObject)output, (String)"souls");
            IMobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeById(new ResourceLocation(type));
            if (mobSoulType == null) {
                throw new JsonParseException("Invalid mob soul type id: " + type);
            }
            return new SoulExtractionRecipe(recipeId, input, mobSoulType, amount);
        }

        public SoulExtractionRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ResourceLocation type = buffer.func_192575_l();
            double souls = buffer.readDouble();
            IMobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeById(type);
            return new SoulExtractionRecipe(recipeId, input, mobSoulType, souls);
        }

        public void toNetwork(PacketBuffer buffer, SoulExtractionRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).func_199564_a(buffer);
            buffer.func_192572_a(recipe.type.getId());
            buffer.writeDouble(recipe.souls);
        }
    }
}

