/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.condition;

import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class AugmentEnabledCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("mysticalagriculture", "augment_enabled");
    private final ResourceLocation augment;

    public AugmentEnabledCondition(ResourceLocation augment) {
        this.augment = augment;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test() {
        IAugment augment = AugmentRegistry.getInstance().getAugmentById(this.augment);
        return augment != null && augment.isEnabled();
    }

    public static class Serializer
    implements IConditionSerializer<AugmentEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, AugmentEnabledCondition value) {
            json.addProperty("augment", value.augment.toString());
        }

        public AugmentEnabledCondition read(JsonObject json) {
            return new AugmentEnabledCondition(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"augment")));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

