/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.block.MonsterBoxBlock;
import vazkii.quark.content.world.gen.MonsterBoxGenerator;
import vazkii.quark.content.world.tile.MonsterBoxTileEntity;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class MonsterBoxModule
extends QuarkModule {
    public static final String TAG_MONSTER_BOX_SPAWNED = "quark:monster_box_spawned";
    public static final ResourceLocation MONSTER_BOX_LOOT_TABLE = new ResourceLocation("quark", "misc/monster_box");
    public static TileEntityType<MonsterBoxTileEntity> tileEntityType;
    @Config(description="The chance for the monster box generator to try and place one in a chunk, 1 is 100%\nThis can be higher than 100% if you want multiple per chunk, , 0 is 0%")
    public static double chancePerChunk;
    @Config
    public static int minY;
    @Config
    public static int maxY;
    @Config
    public static int minMobCount;
    @Config
    public static int maxMobCount;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static boolean enableExtraLootTable;
    @Config(description="How many blocks to search vertically from a position before trying to place a block. Higher means you'll get more boxes in open spaces.")
    public static int searchRange;
    public static Block monster_box;

    @Override
    public void construct() {
        monster_box = new MonsterBoxBlock(this);
        tileEntityType = TileEntityType.Builder.func_223042_a(MonsterBoxTileEntity::new, (Block[])new Block[]{monster_box}).func_206865_a(null);
        RegistryHelper.register(tileEntityType, (String)"monster_box");
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new MonsterBoxGenerator(dimensions), GenerationStage.Decoration.UNDERGROUND_DECORATION, 6);
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        LootTable loot;
        LivingEntity entity = event.getEntityLiving();
        if (enableExtraLootTable && entity.func_130014_f_() instanceof ServerWorld && entity.getPersistentData().func_74767_n(TAG_MONSTER_BOX_SPAWNED) && entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e) && event.getSource().func_76346_g() instanceof PlayerEntity && (loot = ((ServerWorld)entity.func_130014_f_()).func_73046_m().func_200249_aQ().func_186521_a(MONSTER_BOX_LOOT_TABLE)) != null) {
            loot.func_216120_b(new LootContext.Builder((ServerWorld)entity.func_130014_f_()).func_216022_a(LootParameterSets.field_216260_a), arg_0 -> ((LivingEntity)entity).func_199701_a_(arg_0));
        }
    }

    static {
        chancePerChunk = 0.8;
        minY = 5;
        maxY = 30;
        minMobCount = 5;
        maxMobCount = 8;
        dimensions = DimensionConfig.overworld(false);
        enableExtraLootTable = true;
        searchRange = 6;
        monster_box = null;
    }
}

