/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.content.world.block.SpeleothemBlock;
import vazkii.quark.content.world.module.SpeleothemsModule;

public class SpeleothemGenerator
extends Generator {
    public SpeleothemGenerator(DimensionConfig dimConfig, BooleanSupplier condition) {
        super(dimConfig, condition);
    }

    @Override
    public void generateChunk(WorldGenRegion world, ChunkGenerator generator, Random rand, BlockPos pos) {
        int spread = 10;
        int tries = SpeleothemsModule.triesPerChunk;
        int innerSpread = 6;
        int innerTries = SpeleothemsModule.speleothemsPerChunk;
        int upperBound = SpeleothemsModule.maxYlevel;
        int offset = 6;
        if (this.isNether((IWorld)world)) {
            upperBound = 128;
            offset = 0;
            tries = SpeleothemsModule.triesPerChunkInNether;
            innerTries = SpeleothemsModule.speleothemsPerChunkInNether;
        }
        if (upperBound > 0) {
            for (int i = 0; i < tries; ++i) {
                BlockPos target = pos.func_177982_a(rand.nextInt(spread), rand.nextInt(upperBound) + offset, rand.nextInt(spread));
                if (!this.placeSpeleothemCluster(rand, (IWorld)world, target, innerSpread, innerTries)) continue;
                ++i;
            }
        }
    }

    private boolean placeSpeleothemCluster(Random random, IWorld world, BlockPos pos, int spread, int tries) {
        if (!this.findAndPlaceSpeleothem(random, world, pos)) {
            return false;
        }
        for (int i = 0; i < tries; ++i) {
            BlockPos target = pos.func_177982_a(random.nextInt(spread * 2 + 1) - spread, random.nextInt(spread + 1) - spread, random.nextInt(spread * 2 + 1) - spread);
            this.findAndPlaceSpeleothem(random, world, target);
        }
        return true;
    }

    private boolean findAndPlaceSpeleothem(Random random, IWorld world, BlockPos pos) {
        BlockState stateAt;
        Direction diff;
        if (!world.func_175623_d(pos)) {
            return false;
        }
        int off = this.isNether(world) ? -1000 : 0;
        boolean up = random.nextBoolean();
        Direction direction = diff = up ? Direction.UP : Direction.DOWN;
        if (!up && world.func_175710_j(pos)) {
            return false;
        }
        do {
            pos = pos.func_177972_a(diff);
            stateAt = world.func_180495_p(pos);
        } while (pos.func_177956_o() > 4 && pos.func_177956_o() < 200 && !stateAt.func_200132_m() && ++off < 10);
        Block type = this.getSpeleothemType(stateAt);
        this.placeSpeleothem(random, world, pos, type, !up);
        return true;
    }

    private void placeSpeleothem(Random random, IWorld world, BlockPos pos, Block type, boolean up) {
        int size;
        if (type == null) {
            return;
        }
        Direction diff = up ? Direction.UP : Direction.DOWN;
        int n = size = random.nextInt(3) == 0 ? 2 : 3;
        if (!up && random.nextInt(20) == 0) {
            size = 1;
        }
        for (int i = 0; i < size; ++i) {
            if (!world.func_175623_d(pos = pos.func_177972_a(diff))) {
                return;
            }
            SpeleothemBlock.SpeleothemSize sizeType = SpeleothemBlock.SpeleothemSize.values()[size - i - 1];
            BlockState targetBlock = (BlockState)type.func_176223_P().func_206870_a(SpeleothemBlock.SIZE, (Comparable)((Object)sizeType));
            world.func_180501_a(pos, targetBlock, 0);
        }
    }

    private Block getSpeleothemType(BlockState state) {
        return SpeleothemsModule.speleothemMapping.get(state.func_177230_c());
    }
}

