/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.quark.base.block.QuarkVineBlock;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.QuarkModule;

public class RootBlock
extends QuarkVineBlock
implements IGrowable {
    public RootBlock(QuarkModule module) {
        super(module, "root", true);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(2) == 0 && this.func_176473_a((IBlockReader)worldIn, pos, state, false)) {
            this.func_225535_a_(worldIn, random, pos, state);
        }
    }

    public static void growMany(IWorld world, Random rand, BlockPos pos, BlockState state, float stopChance) {
        BlockPos next = pos;
        while ((next = RootBlock.growAndReturnLastPos(world, next, state)) != null && rand.nextFloat() >= stopChance) {
        }
    }

    public static BlockPos growAndReturnLastPos(IWorld world, BlockPos pos, BlockState state) {
        BlockPos down = pos.func_177977_b();
        for (Direction facing : MiscUtil.HORIZONTALS) {
            BooleanProperty prop = RootBlock.func_176267_a((Direction)facing);
            if (!((Boolean)state.func_177229_b((Property)prop)).booleanValue()) continue;
            BlockPos ret = RootBlock.growInFacing(world, down, facing);
            if (ret == null) break;
            BlockState setState = (BlockState)state.func_177230_c().func_176223_P().func_206870_a((Property)prop, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(ret, setState, 2);
            return ret;
        }
        return null;
    }

    public static BlockPos growInFacing(IWorld world, BlockPos pos, Direction facing) {
        if (!world.func_175623_d(pos)) {
            return null;
        }
        BlockPos check = pos.func_177972_a(facing);
        if (RootBlock.isAcceptableNeighbor(world, check, facing.func_176734_d())) {
            return pos;
        }
        pos = check;
        if (!world.func_175623_d(check)) {
            return null;
        }
        check = pos.func_177972_a(facing);
        if (RootBlock.isAcceptableNeighbor(world, check, facing.func_176734_d())) {
            return pos;
        }
        return null;
    }

    public static boolean isAcceptableNeighbor(IWorld world, BlockPos pos, Direction side) {
        BlockState iblockstate = world.func_180495_p(pos);
        return Block.func_208061_a((VoxelShape)iblockstate.func_196952_d((IBlockReader)world, pos), (Direction)side) && iblockstate.func_185904_a() == Material.field_151576_e;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean client) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            return serverWorld.func_226659_b_(pos, 0) < 7;
        }
        return false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        RootBlock.growAndReturnLastPos((IWorld)world, pos, state);
    }
}

