/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.ITrowelable;
import vazkii.quark.api.IUsageTickerOverride;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.tools.module.TrowelModule;

public class TrowelItem
extends QuarkItem
implements IUsageTickerOverride {
    private static final String TAG_PLACING_SEED = "placing_seed";
    private static final String TAG_LAST_STACK = "last_stack";

    public TrowelItem(QuarkModule module) {
        super("trowel", module, new Item.Properties().func_200918_c(255).func_200916_a(ItemGroup.field_78040_i));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ArrayList<ItemStack> targets = new ArrayList<ItemStack>();
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!TrowelItem.isValidTarget(stack)) continue;
            targets.add(stack);
        }
        ItemStack ourStack = player.func_184586_b(hand);
        if (targets.isEmpty()) {
            return ActionResultType.PASS;
        }
        long seed = ItemNBTHelper.getLong((ItemStack)ourStack, (String)TAG_PLACING_SEED, (long)0L);
        Random rand = new Random(seed);
        ItemNBTHelper.setLong((ItemStack)ourStack, (String)TAG_PLACING_SEED, (long)rand.nextLong());
        ItemStack target = (ItemStack)targets.get(rand.nextInt(targets.size()));
        int count = target.func_190916_E();
        ActionResultType result = this.placeBlock(target, context);
        if (player.func_184812_l_()) {
            target.func_190920_e(count);
        }
        if (result.func_226246_a_()) {
            CompoundNBT cmp = target.serializeNBT();
            ItemNBTHelper.setCompound((ItemStack)ourStack, (String)TAG_LAST_STACK, (CompoundNBT)cmp);
            if (TrowelModule.maxDamage > 0) {
                MiscUtil.damageStack(player, hand, context.func_195996_i(), 1);
            }
        }
        return result;
    }

    private ActionResultType placeBlock(ItemStack itemstack, ItemUseContext context) {
        if (TrowelItem.isValidTarget(itemstack)) {
            Item item = itemstack.func_77973_b();
            TrowelBlockItemUseContext newContext = new TrowelBlockItemUseContext(context, itemstack);
            return item.func_195939_a((ItemUseContext)newContext);
        }
        return ActionResultType.PASS;
    }

    private static boolean isValidTarget(ItemStack stack) {
        Item item = stack.func_77973_b();
        return !stack.func_190926_b() && (item instanceof BlockItem || item instanceof ITrowelable);
    }

    public static ItemStack getLastStack(ItemStack stack) {
        CompoundNBT cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_LAST_STACK, (boolean)false);
        return ItemStack.func_199557_a((CompoundNBT)cmp);
    }

    public int getMaxDamage(ItemStack stack) {
        return TrowelModule.maxDamage;
    }

    public boolean func_77645_m() {
        return TrowelModule.maxDamage > 0;
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack) {
        return TrowelItem.getLastStack(stack);
    }

    class TrowelBlockItemUseContext
    extends BlockItemUseContext {
        public TrowelBlockItemUseContext(ItemUseContext context, ItemStack stack) {
            super(context.func_195991_k(), context.func_195999_j(), context.func_221531_n(), stack, new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k()));
        }
    }
}

