/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.automation.entity.GravisandEntity;

public class GravisandBlock
extends QuarkBlock {
    public GravisandBlock(String regname, QuarkModule module, ItemGroup creativeTab, AbstractBlock.Properties properties) {
        super(regname, module, creativeTab, properties);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.checkRedstone(world, pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(worldIn, pos);
    }

    private void checkRedstone(World worldIn, BlockPos pos) {
        boolean powered = worldIn.func_175640_z(pos);
        if (powered) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return 15;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.field_72995_K && this.checkFallable((World)worldIn, pos)) {
            for (Direction face : Direction.values()) {
                BlockPos offPos = pos.func_177972_a(face);
                BlockState offState = worldIn.func_180495_p(offPos);
                if (offState.func_177230_c() != this) continue;
                worldIn.func_205220_G_().func_205360_a(offPos, (Object)this, 2);
            }
        }
    }

    private boolean checkFallable(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            if (this.tryFall(worldIn, pos, Direction.DOWN)) {
                return true;
            }
            return this.tryFall(worldIn, pos, Direction.UP);
        }
        return false;
    }

    private boolean tryFall(World worldIn, BlockPos pos, Direction facing) {
        BlockPos target = pos.func_177972_a(facing);
        if ((worldIn.func_175623_d(target) || GravisandBlock.canFallThrough((IWorldReader)worldIn, pos, worldIn.func_180495_p(target))) && pos.func_177956_o() >= 0) {
            GravisandEntity entity = new GravisandEntity(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, facing.func_96559_d());
            worldIn.func_217376_c((Entity)entity);
            return true;
        }
        return false;
    }

    public static boolean canFallThrough(IWorldReader world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return state.isAir((IBlockReader)world, pos) || block == Blocks.field_150480_ab || material.func_76224_d() || material.func_76222_j();
    }
}

