/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.quark.base.item.QuarkSpawnEggItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.type.CostSensitiveEntitySpawnConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;

@Mod.EventBusSubscriber(modid="quark")
public class EntitySpawnHandler {
    private static List<TrackedSpawnConfig> trackedSpawnConfigs = new LinkedList<TrackedSpawnConfig>();

    public static <T extends MobEntity> void registerSpawn(QuarkModule module, EntityType<T> entityType, EntityClassification classification, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate, EntitySpawnConfig config) {
        EntitySpawnPlacementRegistry.func_209343_a(entityType, (EntitySpawnPlacementRegistry.PlacementType)placementType, (Heightmap.Type)heightMapType, placementPredicate);
        EntitySpawnHandler.track(module, entityType, classification, config, false);
    }

    public static <T extends MobEntity> void track(QuarkModule module, EntityType<T> entityType, EntityClassification classification, EntitySpawnConfig config, boolean secondary) {
        config.setModule(module);
        trackedSpawnConfigs.add(new TrackedSpawnConfig(entityType, classification, config, secondary));
    }

    public static void addEgg(EntityType<?> entityType, int color1, int color2, EntitySpawnConfig config) {
        EntitySpawnHandler.addEgg(entityType, color1, color2, config.module, config::isEnabled);
    }

    public static void addEgg(EntityType<?> entityType, int color1, int color2, QuarkModule module, BooleanSupplier enabledSupplier) {
        new QuarkSpawnEggItem(entityType, color1, color2, entityType.getRegistryName().func_110623_a() + "_spawn_egg", module, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setCondition(enabledSupplier);
    }

    @SubscribeEvent
    public static void onBiomeLoaded(BiomeLoadingEvent ev) {
        MobSpawnInfoBuilder builder = ev.getSpawns();
        for (TrackedSpawnConfig c : trackedSpawnConfigs) {
            List l = builder.getSpawner(c.classification);
            if (!c.secondary) {
                l.removeIf(e -> e.field_242588_c.equals(c.entityType));
            }
            if (c.config.isEnabled() && c.config.biomes.canSpawn(ev)) {
                l.add(c.entry);
            }
            if (!(c.config instanceof CostSensitiveEntitySpawnConfig)) continue;
            CostSensitiveEntitySpawnConfig csc = (CostSensitiveEntitySpawnConfig)c.config;
            builder.func_242573_a(c.entityType, csc.spawnCost, csc.maxCost);
        }
    }

    public static void refresh() {
        for (TrackedSpawnConfig c : trackedSpawnConfigs) {
            c.refresh();
        }
    }

    private static class TrackedSpawnConfig {
        final EntityType<?> entityType;
        final EntityClassification classification;
        final EntitySpawnConfig config;
        final boolean secondary;
        MobSpawnInfo.Spawners entry;

        TrackedSpawnConfig(EntityType<?> entityType, EntityClassification classification, EntitySpawnConfig config, boolean secondary) {
            this.entityType = entityType;
            this.classification = classification;
            this.config = config;
            this.secondary = secondary;
            this.refresh();
        }

        void refresh() {
            this.entry = new MobSpawnInfo.Spawners(this.entityType, this.config.spawnWeight, Math.min(this.config.minGroupSize, this.config.maxGroupSize), Math.max(this.config.minGroupSize, this.config.maxGroupSize));
        }
    }
}

