/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.ITransferManager;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.management.module.EasyTransferingModule;

public class InventoryTransferHandler {
    public static void transfer(PlayerEntity player, boolean isRestock, boolean smart) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(EasyTransferingModule.class) || player.func_175149_v() || !InventoryTransferHandler.accepts(player.field_71070_bA, player)) {
            return;
        }
        Transfer transfer = isRestock ? new Restock(player, smart) : new Transfer(player, smart);
        transfer.execute();
    }

    private static boolean hasProvider(Object te) {
        return te instanceof TileEntity && ((TileEntity)te).getCapability(QuarkCapabilities.TRANSFER).isPresent();
    }

    private static ITransferManager getProvider(Object te) {
        return (ITransferManager)((TileEntity)te).getCapability(QuarkCapabilities.TRANSFER).orElse(null);
    }

    public static boolean accepts(Container container, PlayerEntity player) {
        if (InventoryTransferHandler.hasProvider(container)) {
            return InventoryTransferHandler.getProvider(container).acceptsTransfer(player);
        }
        return container.field_75151_b.size() - player.field_71071_by.field_70462_a.size() >= 27;
    }

    public static interface TransferPredicate
    extends BiPredicate<ItemStack, IItemHandler> {
    }

    public static class ContainerWrapper
    extends InvWrapper {
        private final Container container;

        public static IItemHandler provideWrapper(Slot slot, Container container) {
            if (slot instanceof SlotItemHandler) {
                IItemHandler handler = ((SlotItemHandler)slot).getItemHandler();
                if (InventoryTransferHandler.hasProvider(handler)) {
                    return InventoryTransferHandler.getProvider(handler).getTransferItemHandler(() -> handler);
                }
                return handler;
            }
            return ContainerWrapper.provideWrapper(slot.field_75224_c, container);
        }

        public static IItemHandler provideWrapper(IInventory inv, Container container) {
            if (InventoryTransferHandler.hasProvider(inv)) {
                return InventoryTransferHandler.getProvider(inv).getTransferItemHandler(() -> new ContainerWrapper(inv, container));
            }
            return new ContainerWrapper(inv, container);
        }

        private ContainerWrapper(IInventory inv, Container container) {
            super(inv);
            this.container = container;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            Slot containerSlot = this.getSlot(slot);
            if (containerSlot == null || !containerSlot.func_75214_a(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        private Slot getSlot(int slotId) {
            IInventory inv = this.getInv();
            for (Slot slot : this.container.field_75151_b) {
                if (slot.field_75224_c != inv || slot.getSlotIndex() != slotId) continue;
                return slot;
            }
            return null;
        }
    }

    public static class PlayerInvWrapper
    extends InvWrapper {
        public PlayerInvWrapper(IInventory inv) {
            super(inv);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                stack = stack.func_77946_l();
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlots() {
            return super.getSlots() - 5;
        }
    }

    public static class Restock
    extends Transfer {
        public Restock(PlayerEntity player, boolean filtered) {
            super(player, filtered);
        }

        @Override
        public void transfer(TransferPredicate predicate) {
            IItemHandler inv = (IItemHandler)((Pair)this.itemHandlers.get(0)).getLeft();
            PlayerInvWrapper playerInv = new PlayerInvWrapper((IInventory)this.player.field_71071_by);
            for (int i = inv.getSlots() - 1; i >= 0; --i) {
                ItemStack copy;
                ItemStack ret;
                ItemStack stackAt = inv.getStackInSlot(i);
                if (stackAt.func_190926_b() || ItemStack.func_77989_b((ItemStack)stackAt, (ItemStack)(ret = this.insertInHandler((IItemHandler)playerInv, copy = stackAt.func_77946_l(), predicate)))) continue;
                inv.extractItem(i, stackAt.func_190916_E() - ret.func_190916_E(), false);
            }
        }
    }

    public static class Transfer {
        public final PlayerEntity player;
        public final boolean smart;
        public final List<Pair<IItemHandler, Double>> itemHandlers = new ArrayList<Pair<IItemHandler, Double>>();

        public Transfer(PlayerEntity player, boolean smart) {
            this.player = player;
            this.smart = smart;
        }

        public void execute() {
            this.locateItemHandlers();
            if (this.itemHandlers.isEmpty()) {
                return;
            }
            if (this.smart) {
                this.smartTransfer();
            } else {
                this.roughTransfer();
            }
            this.player.field_71069_bz.func_75142_b();
            this.player.field_71070_bA.func_75142_b();
        }

        public void smartTransfer() {
            this.transfer((stack, handler) -> {
                int slots = handler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stackAt = handler.getStackInSlot(i);
                    if (stackAt.func_190926_b()) continue;
                    boolean itemEqual = stack.func_77973_b() == stackAt.func_77973_b();
                    boolean damageEqual = stack.func_77952_i() == stackAt.func_77952_i();
                    boolean nbtEqual = ItemStack.func_77970_a((ItemStack)stackAt, (ItemStack)stack);
                    if (itemEqual && damageEqual && nbtEqual) {
                        return true;
                    }
                    if (!stack.func_77984_f() || stack.func_77976_d() != 1 || !itemEqual || !nbtEqual) continue;
                    return true;
                }
                return false;
            });
        }

        public void roughTransfer() {
            this.transfer((stack, handler) -> true);
        }

        public void locateItemHandlers() {
            Container c = this.player.field_71070_bA;
            for (Slot s : c.field_75151_b) {
                IInventory inv = s.field_75224_c;
                if (inv == this.player.field_71071_by) continue;
                this.itemHandlers.add((Pair<IItemHandler, Double>)Pair.of((Object)ContainerWrapper.provideWrapper(s, c), (Object)0.0));
                break;
            }
        }

        public void transfer(TransferPredicate predicate) {
            PlayerInventory inv = this.player.field_71071_by;
            for (int i = PlayerInventory.func_70451_h(); i < inv.field_70462_a.size(); ++i) {
                ItemStack ret;
                ItemStack stackAt = inv.func_70301_a(i);
                if (stackAt.func_190926_b() || ItemStack.func_77989_b((ItemStack)stackAt, (ItemStack)(ret = this.insert(stackAt, predicate)))) continue;
                inv.func_70299_a(i, ret);
            }
        }

        public ItemStack insert(ItemStack stack, TransferPredicate predicate) {
            ItemStack ret = stack.func_77946_l();
            for (Pair<IItemHandler, Double> pair : this.itemHandlers) {
                IItemHandler handler = (IItemHandler)pair.getLeft();
                ret = this.insertInHandler(handler, ret, predicate);
                if (!ret.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            return ret;
        }

        public ItemStack insertInHandler(IItemHandler handler, ItemStack stack, TransferPredicate predicate) {
            if (predicate.test(stack, handler)) {
                ItemStack retStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                if (retStack.func_190926_b()) {
                    return retStack;
                }
                retStack = retStack.func_77946_l();
                return retStack;
            }
            return stack;
        }
    }
}

