/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldData {
    static final Map<IWorld, WorldData> DATA_MAP = new ConcurrentHashMap<IWorld, WorldData>();
    protected final Map<ChunkPos, DepositGenResult> generatedDeposits = new ConcurrentHashMap<ChunkPos, DepositGenResult>();

    @Nonnull
    public static WorldData getData(IWorld world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData();
            DATA_MAP.put(world, data);
        }
        return data;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        DATA_MAP.remove(event.getWorld());
    }

    public static CompoundNBT getLevelData(ChunkDataEvent event) {
        return event.getData().func_74775_l("Level");
    }

    @SubscribeEvent
    public static void onChunkDataLoading(ChunkDataEvent.Load event) {
        IWorld world = event.getWorld();
        if (world == null) {
            return;
        }
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return;
        }
        CompoundNBT compound = WorldData.getLevelData((ChunkDataEvent)event);
        DepositGenResult result = DepositGenResult.EMPTY.readFrom(compound);
        if (!result.isEmpty()) {
            WorldData.getData(world).addDepositGenResult(result);
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaving(ChunkDataEvent.Save event) {
        IWorld world = event.getWorld();
        if (world == null) {
            return;
        }
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        DepositGenResult deposit = WorldData.getData((IWorld)world).generatedDeposits.get(pos);
        if (deposit != null) {
            CompoundNBT compound = WorldData.getLevelData((ChunkDataEvent)event);
            deposit.writeTo(compound);
        }
    }

    public void addDepositGenResult(DepositGenResult result) {
        if (!result.isEmpty()) {
            this.generatedDeposits.put(new ChunkPos(result.pos), result);
        }
    }

    public Map<ChunkPos, DepositGenResult> getGeneratedDeposits() {
        return Collections.unmodifiableMap(this.generatedDeposits);
    }
}

