/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

public class VanillaOre
extends AbstractOre
implements IRelatedUnit {
    protected final UnitId oreId;
    protected final Generation generation;
    protected final IntBounds veinsInChunk;
    protected final IntBounds blocksInVein;

    public VanillaOre(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.oreId = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"oreId", (UnitId)props.id, (String)"Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n");
        this.generation = Generation.from(config, category, "Generation type used for this ore. Possible values:\n    VANILLA - vanilla generation without any changes,\n    CUSTOM - generation according to this config,\n    NONE - no generation at all.\nNote that changing this setting requires a WORLD RESTART in order to update every biome's features.");
        this.veinsInChunk = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"VeinsInChunk", (IntBounds)props.veins, (IntBounds)Properties.SIZE_BOUNDS, (String)"Number of ore veins to generate in each chunk.");
        this.blocksInVein = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"BlocksInVein", (IntBounds)props.size, (IntBounds)Properties.SIZE_BOUNDS, (String)"Number of ore blocks in each vein.");
        this.saveConfig();
    }

    public UnitId getRelatedId() {
        return this.oreId;
    }

    public Generation getGeneration() {
        return this.generation;
    }

    public IntBounds getVeinsInChunk() {
        return this.veinsInChunk;
    }

    public IntBounds getBlocksInVein() {
        return this.blocksInVein;
    }

    @Override
    protected int generate(IServerWorld world, BlockPos startPos, int amount, final boolean testing) {
        return new OreChain((IWorld)world, startPos, amount, this.miscellaneous){

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return VanillaOre.this.replaceWithOre(this.world, pos);
            }

            protected boolean isValidPath(BlockPos pos) {
                return VanillaOre.this.isValidPosition(this.world, pos, this.startPos, testing);
            }

            protected boolean isValidBlock(BlockPos pos) {
                return VanillaOre.this.isValidPosition(this.world, pos, this.startPos, testing) && VanillaOre.this.canBeReplaced(this.world, pos, testing);
            }
        }.generate().getCount();
    }

    @Deprecated
    protected int generateVanilla(IServerWorld world, BlockPos startPos, int amount, boolean testing) {
        int count = 0;
        float f = CommonMath.Random.getFloat() * (float)Math.PI;
        double minX = (float)(startPos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)amount / 8.0f;
        double maxX = (float)(startPos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)amount / 8.0f;
        double minZ = (float)(startPos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)amount / 8.0f;
        double maxZ = (float)(startPos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)amount / 8.0f;
        double minY = startPos.func_177956_o() + CommonMath.Random.between((int)-2, (int)2);
        double maxY = startPos.func_177956_o() + CommonMath.Random.between((int)-2, (int)2);
        block0: for (int i = 0; i < amount; ++i) {
            float progress = (float)i / (float)amount;
            double centerX = minX + (maxX - minX) * (double)progress;
            double centerY = minY + (maxY - minY) * (double)progress;
            double centerZ = minZ + (maxZ - minZ) * (double)progress;
            double d9 = CommonMath.Random.getDouble() * (double)amount / 16.0;
            double offsetXZ = (double)(MathHelper.func_76126_a((float)((float)Math.PI * progress)) + 1.0f) * d9 + 1.0;
            double offsetY = (double)(MathHelper.func_76126_a((float)((float)Math.PI * progress)) + 1.0f) * d9 + 1.0;
            int startX = MathHelper.func_76128_c((double)(centerX - offsetXZ / 2.0));
            int endX = MathHelper.func_76128_c((double)(centerX + offsetXZ / 2.0));
            int startY = MathHelper.func_76128_c((double)(centerY - offsetY / 2.0));
            int endY = MathHelper.func_76128_c((double)(centerY + offsetY / 2.0));
            int startZ = MathHelper.func_76128_c((double)(centerZ - offsetXZ / 2.0));
            int endZ = MathHelper.func_76128_c((double)(centerZ + offsetXZ / 2.0));
            for (int x = startX; x <= endX; ++x) {
                double normX = ((double)x + 0.5 - centerX) / (offsetXZ / 2.0);
                if (!(normX * normX < 1.0)) continue;
                for (int y = startY; y <= endY; ++y) {
                    double normY = ((double)y + 0.5 - centerY) / (offsetY / 2.0);
                    if (!(normX * normX + normY * normY < 1.0)) continue;
                    for (int z = startZ; z <= endZ; ++z) {
                        BlockPos pos;
                        double normZ = ((double)z + 0.5 - centerZ) / (offsetXZ / 2.0);
                        if (count >= amount) continue block0;
                        if (!(normX * normX + normY * normY + normZ * normZ < 1.0) || !this.isValidPosition((IWorld)world, pos = new BlockPos(x, y, z), startPos, testing) || !this.canBeReplaced((IWorld)world, pos, testing) || !this.replaceWithOre((IWorld)world, pos)) continue;
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    public boolean matches(Supplier<ConfiguredFeature<?, ?>> supplier) {
        ConfiguredFeature configuredFeature = supplier.get();
        if (configuredFeature == null) {
            return false;
        }
        while (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
            configuredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.get();
        }
        Feature feature = configuredFeature.field_222737_a;
        if (feature == Feature.field_202290_aj || feature == Feature.field_236289_V_ || feature == Feature.field_202294_an) {
            IFeatureConfig config = configuredFeature.field_222738_b;
            BlockState blockState = null;
            if (config instanceof ReplaceBlockConfig) {
                blockState = ((ReplaceBlockConfig)config).field_202458_b;
            }
            if (config instanceof OreFeatureConfig) {
                blockState = ((OreFeatureConfig)config).field_202444_d;
            }
            if (blockState != null && this.getRelatedId().matches(blockState)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean replaceWithOre(IWorld world, BlockPos pos) {
        BlockState state = this.getRelatedId().getFirstMatchedState();
        return state != null && world.func_180501_a(pos, state, 18);
    }

    @Override
    public boolean isValid() {
        return !this.replaceableBlocks.isEmpty() && this.getRelatedId().getFirstMatchedState() != null;
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        protected static final IntBounds SIZE_BOUNDS = IntBounds.from((Integer)1, (Integer)256);
        public IntBounds size = IntBounds.ZERO;
        public IntBounds veins = IntBounds.ZERO;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> overworld() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T veins(int max) {
            this.veins = IntBounds.from((Integer)max, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T size(int max) {
            this.size = IntBounds.from((Integer)1, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Generation {
        VANILLA,
        CUSTOM,
        NONE;


        public static Generation from(UnitConfig config, String category, String comment) {
            String name = UnitConfig.getStr((UnitConfig)config, (String)category, (String)"generation", (String)"vanilla", (String)comment);
            for (Generation type : Generation.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            AdLods.getInstance().getLogger().error("Invalid generation type: " + name);
            return VANILLA;
        }
    }
}

