/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaOre;
import com.endertech.minecraft.mods.adlods.world.AbstractGenerator;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class VanillaController
extends AbstractGenerator {
    private final ForgeMod mod;
    private Optional<VanillaOres> ores = Optional.empty();

    public VanillaController(ForgeMod mod) {
        super(mod, "vanilla_controller");
        this.mod = mod;
    }

    public void loadOres() {
        this.ores = Optional.of(new VanillaOres(this.mod));
        this.ores.get().onPostInit();
    }

    public void unloadOres() {
        this.ores = Optional.empty();
    }

    @Override
    public boolean generateAt(ISeedReader world, ChunkPos chunkPos) {
        if (!this.ores.isPresent()) {
            return false;
        }
        List passed = this.ores.get().getAll().stream().filter(ore -> ore.getGeneration() == VanillaOre.Generation.CUSTOM && ore.inAllowedDimenstion((IServerWorld)world) && ore.isValid()).collect(Collectors.toList());
        Collections.shuffle(passed);
        int count = 0;
        ChunkBounds chunkBounds = ChunkBounds.from((ChunkPos)chunkPos);
        for (VanillaOre ore2 : passed) {
            int maxVeins = ore2.getVeinsInChunk().randomBetween();
            for (int i = 0; i < maxVeins; ++i) {
                BlockPos pos = new BlockPos(chunkBounds.getX().randomBetween().intValue(), ore2.getAltitude().randomBetween().intValue(), chunkBounds.getZ().randomBetween().intValue());
                int amount = ore2.getBlocksInVein().randomBetween();
                count += ore2.generate((IServerWorld)world, pos, amount, false);
            }
        }
        return count > 0;
    }

    @Override
    public void doAdditions(BiomeLoadingEvent biome) {
        if (!this.ores.isPresent()) {
            this.loadOres();
        }
        List features = biome.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES);
        for (VanillaOre ore : this.ores.get().getAll()) {
            if (ore.getGeneration() != VanillaOre.Generation.CUSTOM) continue;
            features.add(() -> this.configuredFeature);
            return;
        }
    }

    @Override
    public void doRemovals(BiomeLoadingEvent biome) {
        if (!this.ores.isPresent()) {
            this.loadOres();
        }
        for (GenerationStage.Decoration stage : new GenerationStage.Decoration[]{GenerationStage.Decoration.UNDERGROUND_DECORATION, GenerationStage.Decoration.UNDERGROUND_ORES}) {
            List features = biome.getGeneration().getFeatures(stage);
            for (VanillaOre ore : this.ores.get().getAll()) {
                if (ore.getGeneration() == VanillaOre.Generation.VANILLA) continue;
                features.removeIf(ore::matches);
            }
        }
    }

    @Override
    public void doOther(BiomeLoadingEvent biome) {
    }

    static class VanillaOres
    extends RelatedUnitsInit<VanillaOre, BuiltIn> {
        public VanillaOres(ForgeMod mod) {
            super(mod, BuiltIn.class);
        }

        public VanillaOre createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
            return new VanillaOre(config, e.props);
        }

        public VanillaOre createCustomUnitFrom(UnitConfig config, String name) {
            UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
            return new VanillaOre(config, (VanillaOre.Properties)VanillaOre.Properties.overworld().id(id));
        }

        static enum BuiltIn implements IForgeEnum
        {
            DIRT((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(10))).altitude(0, 255))),
            GRAVEL((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(8))).altitude(0, 255))),
            GRANITE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(10))).altitude(0, 79))),
            DIORITE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(10))).altitude(0, 79))),
            ANDESITE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(33))).veins(10))).altitude(0, 79))),
            COAL_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(17))).veins(20))).altitude(0, 127))),
            IRON_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(9))).veins(20))).altitude(0, 63))),
            REDSTONE_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(8))).veins(8))).altitude(0, 15))),
            LAPIS_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(7))).veins(1))).altitude(0, 30))),
            GOLD_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(9))).veins(2))).altitude(0, 31))),
            DIAMOND_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(8))).veins(1))).altitude(0, 15))),
            EMERALD_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(3))).veins(1))).altitude(4, 31))),
            INFESTED_STONE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.overworld().size(9))).veins(7))).altitude(0, 63))),
            MAGMA_BLOCK((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(33))).veins(4))).altitude(27, 36))),
            NETHER_QUARTZ_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(14))).veins(16))).altitude(10, 117))),
            NETHER_GOLD_ORE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(10))).veins(10))).altitude(10, 117))),
            ANCIENT_DEBRIS((VanillaOre.Properties)((Object)((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(3))).veins(2))).altitude(8, 119))).exposed(false))),
            SOUL_SAND((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(12))).veins(12))).altitude(1, 32))),
            BLACKSTONE((VanillaOre.Properties)((Object)((AbstractOre.Properties)((Object)((VanillaOre.Properties)((Object)VanillaOre.Properties.nether().size(33))).veins(2))).altitude(1, 32)));

            public final VanillaOre.Properties<?> props;

            private BuiltIn(VanillaOre.Properties<?> props) {
                this.props = (VanillaOre.Properties)props.emptyToEnumId(this, false);
            }
        }
    }
}

