/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public abstract class OreChain
extends WorldSearch.BlockChain {
    protected int count = 0;
    protected final Miscellaneous miscellaneous;

    protected OreChain(IWorld world, BlockPos startPos, int maxLength, Miscellaneous miscellaneous) {
        super(world, startPos, maxLength);
        this.miscellaneous = miscellaneous;
    }

    public abstract boolean replaceWithOre(BlockPos var1);

    public OreChain generate() {
        this.count = 0;
        this.build();
        return this;
    }

    public int getCount() {
        return this.count;
    }

    protected Collection<Direction> getDirections() {
        GameWorld.Directions directions = GameWorld.Directions.of();
        for (Direction.Axis axis : Direction.Axis.values()) {
            Direction.Plane plane = axis.func_176716_d();
            if (!this.isValidPlane(plane)) continue;
            plane.func_239636_a_().forEach(arg_0 -> ((GameWorld.Directions)directions).add(arg_0));
            this.getGroupingDirection(axis).ifPresent(arg_0 -> ((GameWorld.Directions)directions).add(arg_0));
        }
        return directions.shuffle().toList();
    }

    protected Optional<Direction> getGroupingDirection(Direction.Axis axis) {
        if (this.blockChain.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = (BlockPos)this.blockChain.get(this.blockChain.size() - 1);
        int delta = pos.func_243648_a(axis) - this.startPos.func_243648_a(axis);
        if (delta == 0) {
            return Optional.empty();
        }
        Direction.AxisDirection axisDirection = delta > 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE;
        return Optional.of(Direction.func_181076_a((Direction.AxisDirection)axisDirection, (Direction.Axis)axis));
    }

    protected boolean isValidPlane(Direction.Plane plane) {
        float props = this.miscellaneous.proportions;
        switch (plane) {
            case VERTICAL: {
                return props < 1.0f ? CommonMath.Random.result((float)props) : true;
            }
            case HORIZONTAL: {
                return props > 1.0f ? CommonMath.Random.result((float)(1.0f / props)) : true;
            }
        }
        return false;
    }

    protected boolean onValidFound(BlockPos pos) {
        if (this.replaceWithOre(pos)) {
            ++this.count;
        }
        return true;
    }
}

