/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;

public class Indicator
implements IHaveConfig {
    protected final UnitConfig config;
    protected final UnitId id;
    protected final List<Circle> circles;
    public final Percentage continuity;
    public final int distortion;

    public Indicator(UnitConfig config, String headCategory, String[] circles) {
        this.config = config;
        String category = this.expandClassCategory(headCategory);
        if (config != null) {
            config.setCategoryComment(category, "Aboveground indicator for this deposit (e.g., a rare flower or a combination of circles of different flowers)");
        }
        this.id = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"id", (UnitId)UnitId.EMPTY, (String)"ID of the single-block indicator.");
        circles = UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"circles", (String[])circles, (String)"Circles of indicators and their radiuses.\nSyntax: indicatorId [, circleRadius]\nThe order of the circles is always shuffled.\nThe circles with the same radius will be randomly selected.\nIf the radius is not defined, it will be selected from the minimum available, starting from 1.\nExamples:\n     minecraft:cornflower, 2\n     minecraft:orange_tulip, 4\n");
        this.circles = Indicator.parseCirclesFrom(circles);
        this.continuity = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"continuity", (Percentage)Percentage.value((float)60.0f), (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Percentage of the indicator shape that will be visible.");
        this.distortion = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"distortion", (int)1, (IntBounds)IntBounds.from((Integer)0, (Integer)16), (String)"Maximum displacement of the indicator shape elements.");
    }

    public static List<Circle> parseCirclesFrom(String[] array) {
        IntBounds radiusBounds = IntBounds.from((Integer)0, (Integer)256);
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split(",");
            UnitId id = UnitId.from((String)split[0].trim());
            Integer radius = null;
            boolean error = id.isEmpty();
            if (split.length > 1) {
                try {
                    radius = Integer.parseInt(split[1].trim());
                    if (!radiusBounds.encloses(radius)) {
                        error = true;
                        AdLods.getInstance().getLogger().error("Circle radius out of " + radiusBounds);
                    }
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                if (id.getFirstMatchedState() == null) continue;
                circles.add(new Circle(id, Optional.ofNullable(radius)));
                continue;
            }
            AdLods.getInstance().getLogger().error("Unable to parse ore indicator from " + CommonString.quoted((String)str));
        }
        return circles;
    }

    public UnitId getCenterId() {
        return this.id;
    }

    public List<Circle> getCircles() {
        return this.circles;
    }

    public List<Circle> getShuffledCircles() {
        ArrayList<Circle> circles = new ArrayList<Circle>(this.getCircles());
        Collections.shuffle(circles);
        return circles;
    }

    public int placeFor(IWorld world, DepositGenResult result) {
        if (result.size < 1) {
            return 0;
        }
        if (this.getCenterId().isEmpty() && this.getCircles().isEmpty()) {
            return 0;
        }
        int count = 0;
        Optional centerPos = Optional.empty();
        BlockState indicator = this.id.getFirstMatchedState();
        int searchRadius = 4;
        if (indicator != null && (centerPos = this.findPositionFor(indicator, world, result.pos, searchRadius)).isPresent() && this.place(world, (BlockPos)centerPos.get(), indicator)) {
            ++count;
        }
        centerPos = centerPos.map(blockPos -> Optional.of(new BlockPos(blockPos.func_177958_n(), result.pos.func_177956_o(), blockPos.func_177952_p()))).orElseGet(() -> Optional.of(result.pos));
        int defaultRadius = 1;
        HashSet<Integer> placedRadiuses = new HashSet<Integer>();
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        for (Circle circle : this.getShuffledCircles()) {
            BlockState indicator2 = circle.indicator.getFirstMatchedState();
            if (indicator2 == null) continue;
            int radius = circle.radius.orElse(defaultRadius);
            if (circle.radius.isPresent()) {
                if (placedRadiuses.contains(radius)) {
                    continue;
                }
            } else {
                while (placedRadiuses.contains(defaultRadius)) {
                    ++defaultRadius;
                }
                radius = defaultRadius;
            }
            for (BlockPos pos : this.getHorizCirclePoints((BlockPos)centerPos.get(), radius)) {
                if (!this.continuity.takeChance()) continue;
                Direction facing = (Direction)CommonCollect.getRandomElementFrom((Collection)directions);
                if (facing != null) {
                    pos = pos.func_177967_a(facing, CommonMath.Random.between((int)0, (int)this.distortion));
                }
                if ((pos = (BlockPos)this.findPositionFor(indicator2, world, pos, 0).orElse(null)) == null || !this.place(world, pos, indicator2)) continue;
                ++count;
            }
            placedRadiuses.add(radius);
        }
        return count;
    }

    protected boolean place(IWorld world, BlockPos pos, BlockState indicator) {
        int flags = 2;
        Block block = indicator.func_177230_c();
        if (block instanceof DoublePlantBlock && world.func_175623_d(pos.func_177984_a())) {
            ((DoublePlantBlock)block).func_196390_a(world, pos, 2);
            return true;
        }
        return world.func_180501_a(pos, indicator, 2);
    }

    protected Optional<BlockPos> findPositionFor(BlockState indicator, IWorld world, BlockPos centerPos, int radius) {
        boolean hasCeiling = world.func_230315_m_().func_236037_d_();
        IntBounds boundsY = IntBounds.from((Integer)centerPos.func_177956_o(), (Integer)(world.func_230315_m_().func_241513_m_() - 1));
        for (int r = 0; r <= radius; ++r) {
            block1: for (BlockPos startPos : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (int)r, (boolean)true)) {
                if (!GameWorld.isBlockLoaded((IWorldReader)world, (BlockPos)startPos)) continue;
                int startY = startPos.func_177956_o();
                if (!hasCeiling) {
                    int oceanFloorY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR, startPos.func_177958_n(), startPos.func_177952_p());
                    int worldSurfaceY = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, startPos.func_177958_n(), startPos.func_177952_p());
                    startY = Math.min(oceanFloorY, worldSurfaceY);
                }
                BlockPos.Mutable pos = new BlockPos.Mutable(startPos.func_177958_n(), startY, startPos.func_177952_p());
                while (boundsY.encloses(Integer.valueOf(pos.func_177956_o()))) {
                    BlockState state = world.func_180495_p((BlockPos)pos);
                    if (state.func_185904_a().func_76230_c()) {
                        pos.func_189536_c(Direction.UP);
                        continue;
                    }
                    if (!indicator.func_196955_c((IWorldReader)world, (BlockPos)pos)) continue block1;
                    Optional<BlockPos> placePos = Optional.of(pos.func_185334_h());
                    FluidState fluidState = state.func_204520_s();
                    if (!(indicator.func_177230_c() instanceof ILiquidContainer ? fluidState.func_206884_a((ITag)FluidTags.field_206959_a) || indicator.func_177230_c() instanceof IWaterLoggable && fluidState.func_206888_e() : fluidState.func_206888_e())) continue block1;
                    return placePos;
                }
            }
        }
        return Optional.empty();
    }

    protected Set<BlockPos> getHorizCirclePoints(BlockPos centerPos, int radius) {
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        Function<Integer, Integer> getOtherCoord = coord -> MathHelper.func_76141_d((float)MathHelper.func_76129_c((float)(radius * radius - coord * coord)));
        for (int dx = -radius; dx <= radius; ++dx) {
            int dz = getOtherCoord.apply(dx);
            points.add(centerPos.func_177982_a(dx, 0, dz));
            points.add(centerPos.func_177982_a(dx, 0, -dz));
        }
        for (int dz = -radius; dz <= radius; ++dz) {
            int dx = getOtherCoord.apply(dz);
            points.add(centerPos.func_177982_a(dx, 0, dz));
            points.add(centerPos.func_177982_a(-dx, 0, dz));
        }
        return points;
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    protected static class Circle {
        public final UnitId indicator;
        public final Optional<Integer> radius;

        public Circle(UnitId indicator) {
            this(indicator, Optional.empty());
        }

        public Circle(UnitId indicator, int radius) {
            this(indicator, Optional.of(radius));
        }

        public Circle(UnitId indicator, Optional<Integer> radius) {
            this.indicator = indicator;
            this.radius = radius;
        }
    }
}

