/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AbstractOre
implements IHaveConfig {
    protected final UnitConfig config;
    protected final CommonCollect.BlackWhiteList<BiomeId> biomes;
    protected final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final IntBounds altitude;
    protected final BlockStatesSet replaceableBlocks;
    protected final Miscellaneous miscellaneous;

    public AbstractOre(UnitConfig config, Properties<?> props) {
        String category = this.getClassCategory();
        this.config = config;
        this.dimensions = Dimensions.from((UnitConfig)config, (String)category, (String)"List of dimensions which this ore can be generated in.", (String[])new String[0], (String[])props.allowedDimensions);
        this.biomes = Biomes.from((UnitConfig)config, (String)category, (String)"List of biomes which this ore can be generated in.");
        this.altitude = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Altitude", (IntBounds)props.altitude, (IntBounds)GameBounds.HEIGHT.getIntBounds(), (String)"Altitude which this ore can be generated at.");
        this.replaceableBlocks = BlockStatesSet.parseFrom((String[])UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"replaceableBlocks", (String[])props.replaceableBlocks, (String)"List of blocks that can be replaced with this ore."));
        this.miscellaneous = Miscellaneous.of(config, category, props.miscellaneous);
        this.saveConfig();
    }

    protected abstract int generate(IServerWorld var1, BlockPos var2, int var3, boolean var4);

    protected abstract boolean replaceWithOre(IWorld var1, BlockPos var2);

    public abstract boolean isValid();

    public UnitConfig getConfig() {
        return this.config;
    }

    public IntBounds getAltitude() {
        return this.altitude;
    }

    public boolean inAllowedDimenstion(IServerWorld world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((World)world.func_201672_e()));
    }

    public boolean inAllowedBiome(IWorld world, BlockPos pos) {
        return this.biomes.isEmpty() || this.biomes.isAllowed((Object)BiomeId.from((IWorld)world, (BlockPos)pos));
    }

    public boolean canBeReplaced(IWorld world, BlockPos pos, boolean testing) {
        if (testing && GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) {
            return true;
        }
        BlockState replaceable = world.func_180495_p(pos);
        return this.replaceableBlocks.contains((Object)replaceable);
    }

    public boolean isValidPosition(IWorld world, BlockPos pos, BlockPos startPos, boolean testing) {
        if (!GameBounds.HEIGHT.getIntBounds().encloses(Integer.valueOf(pos.func_177956_o()))) {
            return false;
        }
        if (testing ? Math.abs(pos.func_177956_o() - startPos.func_177956_o()) > this.altitude.length() / 2 : !this.altitude.encloses(Integer.valueOf(pos.func_177956_o()))) {
            return false;
        }
        if (this.canCauseCascadingWorldGen(world, pos)) {
            return false;
        }
        if (!testing && !this.inAllowedBiome(world, pos)) {
            return false;
        }
        return testing || this.miscellaneous.exposed || !this.exposedToAir(world, pos);
    }

    protected boolean exposedToAir(IWorld world, BlockPos posIn) {
        for (BlockPos pos : GameWorld.Positions.getAroundCube((BlockPos)posIn)) {
            if (!GameWorld.isBlockLoaded((IWorldReader)world, (BlockPos)pos)) {
                return true;
            }
            if (!GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean canCauseCascadingWorldGen(IWorld world, BlockPos pos) {
        return !GameWorld.isBlockLoaded((IWorldReader)world, (BlockPos)pos);
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public IntBounds altitude = IntBounds.ZERO;
        public String[] replaceableBlocks = new String[0];
        public String[] allowedDimensions = new String[0];
        public Miscellaneous.Properties<?> miscellaneous = Miscellaneous.Properties.of();

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T dimension(Dimensions dimension) {
            return ((Properties)((Object)this.allowedDimensions(dimension.dimensionId.toResourceLocation().toString()))).replaceableBlocks(dimension.replaceableBlockId.toString());
        }

        public T altitude(int min, int max) {
            this.altitude = IntBounds.from((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T allowedDimensions(String ... dimensions) {
            this.allowedDimensions = dimensions;
            return (T)((Object)((Properties)this.self));
        }

        public T replaceableBlocks(String ... blocks) {
            this.replaceableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T exposed(boolean value) {
            this.miscellaneous.exposed(value);
            return (T)((Object)((Properties)this.self));
        }
    }
}

