/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class Deposit
extends AbstractOre {
    public static float globalSizeMultiplier = 1.0f;
    public static float globalSpawnRateMultiplier = 1.0f;
    protected final boolean enabled;
    protected final String name;
    protected final IntBounds size;
    protected final int rarity;
    protected final CommonCollect.WeightedList<WeightedOre> ores;
    protected final Percentage chance;
    protected final Indicator indicator;

    public Deposit(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.name = props.name;
        this.enabled = UnitConfig.readConfigEnabled((UnitConfig)config, (boolean)true);
        this.size = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Size", (IntBounds)props.size, (IntBounds)Size.BOUNDS, (String)"Size limits (in blocks) of this deposit.");
        this.rarity = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"rarity", (int)props.rarity, (IntBounds)Rarity.BOUNDS, (String)"Rarity (in chunks) of this deposit.\nHigher values give more rare deposit spawning.\nExample: value of 1000, means that 1 deposit can be spawned per 1000 chunks,\n that gives us 1 / 1000 * 100% = 0.1% chance of spawing per chunk.");
        this.chance = Percentage.value((float)(Percentage.from((int)1, (int)this.rarity).getValue() * globalSpawnRateMultiplier));
        this.indicator = new Indicator(config, category, props.indicatorCircles);
        this.ores = Deposit.parseOresFrom(UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"ores", (String[])props.ores, (String)"List of ores and their weights for this deposit.\nSyntax: oreId [, weight]\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n\nWeight is used to define the proportions of the ores. For example, the definition:\n     #forge:ores/gold, 1\n     #forge:ores/iron, 5\n means that gold and iron will be in the proportion 1 to 5."), state -> {
            String name = Optional.ofNullable(state.func_177230_c().getRegistryName()).map(ResourceLocation::func_110623_a).orElse("");
            if (name.contains("nether")) {
                return this.dimensions.isAllowed((Object)Dimensions.THE_NETHER.dimensionId);
            }
            if (name.startsWith("end_")) {
                return this.dimensions.isAllowed((Object)Dimensions.THE_END.dimensionId);
            }
            return true;
        });
        this.saveConfig();
    }

    public static CommonCollect.WeightedList<WeightedOre> parseOresFrom(String[] array, Predicate<BlockState> filter) {
        CommonCollect.WeightedList ores = new CommonCollect.WeightedList();
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split(",");
            UnitId id = UnitId.from((String)split[0].trim());
            int proportion = 1;
            boolean error = id.isEmpty();
            if (split.length > 1) {
                try {
                    proportion = Integer.parseInt(split[1].trim());
                    if (proportion <= 0) {
                        error = true;
                    }
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                BlockStatesSet set;
                BlockState state = Optional.ofNullable(id.getFirstMatchedState()).filter(filter).orElse(null);
                if (state == null && (set = id.getAllMatchedBlockStates()) != null && (state = (BlockState)set.getBlocksWithAllStates().stream().map(Block::func_176223_P).filter(filter).findFirst().orElse(null)) == null) {
                    state = set.stream().filter(filter).findFirst().orElse(null);
                }
                if (state == null) continue;
                ores.add((CommonCollect.IWeighted)new WeightedOre(state, proportion));
                continue;
            }
            AdLods.getInstance().getLogger().error("Unable to parse ore from " + CommonString.quoted((String)str));
        }
        return ores;
    }

    public DepositGenResult generateAt(IServerWorld world, ChunkPos chunkPos) {
        ChunkBounds chunkBounds = ChunkBounds.from((ChunkPos)chunkPos);
        return this.generateAt(world, chunkBounds.getX().randomBetween(), chunkBounds.getZ().randomBetween());
    }

    public DepositGenResult generateAt(IServerWorld world, int posX, int posZ) {
        BlockPos startPos = new BlockPos(posX, this.altitude.randomBetween().intValue(), posZ);
        int amount = Math.round((float)this.size.randomBetween().intValue() * globalSizeMultiplier);
        int minSize = Math.round((float)this.size.min.intValue() * globalSizeMultiplier);
        DepositGenResult result = this.generateAt(world, startPos, amount, false);
        if (result.size >= minSize) {
            this.indicator.placeFor((IWorld)world, result);
        }
        return result;
    }

    public DepositGenResult generateAt(IServerWorld world, BlockPos startPos, int amount, boolean testing) {
        if (!testing && !this.inAllowedDimenstion(world)) {
            ForgeEndertech.debugMsg((String)("Not in allowable dimension for " + this.getName() + " deposit"));
            return new DepositGenResult(this.getName(), startPos, 0);
        }
        int count = this.generate(world, startPos, amount, testing);
        DepositGenResult result = new DepositGenResult(this.getName(), startPos, count);
        ServerWorld dataworld = world.func_201672_e();
        WorldData.getData((IWorld)dataworld).addDepositGenResult(result);
        ForgeEndertech.debugMsg((String)result.toString());
        return result;
    }

    @Override
    protected int generate(IServerWorld world, BlockPos startPos, int amount, final boolean testing) {
        return new OreChain((IWorld)world, startPos, amount, this.miscellaneous){

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return Deposit.this.replaceWithOre(this.world, pos);
            }

            protected boolean isValidPath(BlockPos pos) {
                return Deposit.this.isValidPosition(this.world, pos, this.startPos, testing) && Deposit.this.isOreBlock(this.world, pos);
            }

            protected boolean isValidBlock(BlockPos pos) {
                return Deposit.this.isValidPosition(this.world, pos, this.startPos, testing) && Deposit.this.canBeReplaced(this.world, pos, testing);
            }
        }.generate().getCount();
    }

    protected BlockStatesSet getReplaceableBlocks() {
        return this.replaceableBlocks;
    }

    @Override
    protected boolean replaceWithOre(IWorld level, BlockPos pos) {
        BlockState state = null;
        state = this.ores.getRandom(level.func_201674_k()).map(WeightedOre::getBlockState).orElse(null);
        if (state != null) {
            return level.func_180501_a(pos, state, 18);
        }
        return false;
    }

    public boolean isOreBlock(IWorld level, BlockPos pos) {
        BlockState state = level.func_180495_p(pos);
        for (WeightedOre ore : this.ores.getElements()) {
            if (!ore.getBlockState().equals(state)) continue;
            return true;
        }
        return GameWorld.isOreBlock((IWorldReader)level, (BlockPos)pos);
    }

    @Override
    public boolean isValid() {
        return this.enabled && !this.name.isEmpty() && !this.ores.isEmpty() && !this.replaceableBlocks.isEmpty() && CommonMath.notZero((double)this.getChance().getValue()) && this.size.min > 0;
    }

    public Percentage getChance() {
        return this.chance;
    }

    public String getName() {
        return this.name;
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        public String name = "";
        public IntBounds size = IntBounds.ZERO;
        public int rarity = 0;
        public String[] ores = new String[0];
        public String[] indicatorCircles = new String[0];

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> overworld() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T name(String name) {
            this.name = name;
            return (T)((Object)((Properties)this.self));
        }

        public T size(int min, int max) {
            this.size = IntBounds.from((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T rarity(int rarity) {
            this.rarity = rarity;
            return (T)((Object)((Properties)this.self));
        }

        public T ores(String ... ores) {
            this.ores = ores;
            return (T)((Object)((Properties)this.self));
        }

        public T indicatorCircles(String ... indicatorCircles) {
            this.indicatorCircles = indicatorCircles;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Size
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.from((Integer)1, (Integer)32000);
        public static final Size ZERO = new Size(0, 0);

        public static Size from(IntBounds bounds) {
            return new Size(bounds.getMin(), bounds.getMax());
        }

        public Size(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Rarity
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.from((Integer)1, (Integer)256000);

        public Rarity(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Altitude
    extends IntBounds {
        public static final IntBounds BOUNDS = GameBounds.HEIGHT.getIntBounds();
        public static final Altitude ZERO = new Altitude(0, 0);

        public static Altitude from(IntBounds bounds) {
            return new Altitude(bounds.getMin(), bounds.getMax());
        }

        public Altitude(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }
}

