/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenerator;
import com.endertech.minecraft.mods.adlods.world.Stripper;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.StringJoiner;
import net.minecraft.block.BlockState;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public final class Commands {
    public static ServerCommand.Arg<String> depositArgument() {
        return ServerCommand.Arg.word((String)"deposit", (context, builder) -> ISuggestionProvider.func_197013_a(AdLods.getInstance().features.generator.getDeposits().stream().map(Deposit::getName), (SuggestionsBuilder)builder));
    }

    public static void listDeposits(ServerCommand.Context context) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Deposit deposit : AdLods.getInstance().features.generator.getDeposits()) {
            joiner.add(deposit.getName());
        }
        context.sendMessage(joiner.toString());
    }

    public static void listGenerated(ServerCommand.Context context) {
        Logger logger = AdLods.getInstance().getLogger();
        Collection<DepositGenResult> deposits = WorldData.getData((IWorld)context.getWorld()).getGeneratedDeposits().values();
        if (deposits.isEmpty()) {
            context.sendMessage("No data on generated deposits are available");
        } else {
            logger.info("Deposits: {");
            deposits.forEach(data -> logger.info("\t" + data));
            logger.info("}");
            context.sendMessage("List of generated deposits (" + deposits.size() + ") was written to .minecraft/logs/latest.log");
        }
    }

    public static void addDeposit(ServerCommand.Context context, boolean isOreIdSpecified) {
        String name;
        DepositGenerator generator = AdLods.getInstance().features.generator;
        Path baseDir = generator.getConfigsDir();
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)(name = Commands.getDepositName(context))).toFile();
        if (configFile.isFile()) {
            context.sendMessage("Config file <" + configFile.getName() + "> already exists!");
            return;
        }
        Deposit deposit = generator.findDepositBy(name).orElse(null);
        if (deposit != null) {
            String fileName = deposit.getConfig().getConfigFile().getName();
            context.sendMessage("Deposit with this name already defined in: " + fileName);
            return;
        }
        int rarity = (Integer)context.getArgument("rarity", Integer.TYPE);
        Deposit.Size size = Deposit.Size.from((IntBounds)context.getArgument("size", IntBounds.class));
        Deposit.Altitude altitude = Deposit.Altitude.from((IntBounds)context.getArgument("altitude", IntBounds.class));
        Deposit deposit2 = isOreIdSpecified ? generator.createDeposit(baseDir, name, size, altitude, rarity, new String[]{UnitId.from((BlockState)((BlockStateInput)context.getArgument("oreId", BlockStateInput.class)).func_197231_a()).toString()}, new String[0]) : generator.createDeposit(baseDir, name, size, altitude, rarity);
        context.sendMessage("Deposit config created");
        if (!deposit2.isValid()) {
            context.sendMessage("Deposit is not valid! Check its parameters");
        }
        if (generator.addDeposit(deposit2)) {
            context.sendMessage("Deposit definition successfully added");
        }
    }

    public static void removeDeposit(ServerCommand.Context context) {
        DepositGenerator generator = AdLods.getInstance().features.generator;
        Path baseDir = generator.getConfigsDir();
        String name = Commands.getDepositName(context);
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)name).toFile();
        Deposit deposit = generator.findDepositBy(name).orElse(null);
        if (deposit != null) {
            if (generator.removeDeposit(deposit)) {
                context.sendMessage("Deposit definition removed");
            }
            configFile = deposit.getConfig().getConfigFile();
        }
        if (configFile.delete()) {
            context.sendMessage("Deposit config removed");
        }
    }

    public static void generateDeposit(ServerCommand.Context context) {
        BlockPos startPos = context.getBlockPos();
        Commands.generateDepositAt(context, startPos.func_177958_n(), startPos.func_177952_p());
    }

    public static void generateDepositAtPos(ServerCommand.Context context) {
        int x = (Integer)context.getArgument("posX", Integer.TYPE);
        int z = (Integer)context.getArgument("posZ", Integer.TYPE);
        Commands.generateDepositAt(context, x, z);
    }

    public static void generateDepositAtChunk(ServerCommand.Context context) {
        int x = (Integer)context.getArgument("chunkX", Integer.TYPE);
        int z = (Integer)context.getArgument("chunkZ", Integer.TYPE);
        ChunkBounds chunkBounds = ChunkBounds.from((ChunkPos)new ChunkPos(x, z));
        Commands.generateDepositAt(context, chunkBounds.getX().randomBetween(), chunkBounds.getZ().randomBetween());
    }

    static void generateDepositAt(ServerCommand.Context context, int posX, int posZ) {
        String name = Commands.getDepositName(context);
        Deposit deposit = AdLods.getInstance().features.generator.findDepositBy(name).orElse(null);
        if (deposit != null) {
            if (context.getWorld().func_195588_v(new BlockPos(posX, 0, posZ))) {
                DepositGenResult result = deposit.generateAt((IServerWorld)context.getWorld(), posX, posZ);
                context.sendMessage(result.toString());
            } else {
                context.sendMessage(BlockPosArgument.field_197278_b.toString());
            }
        } else {
            context.sendMessage(Commands.depositNotFoundMsg(name));
        }
    }

    public static void testDeposit(ServerCommand.Context context) {
        String name = Commands.getDepositName(context);
        Deposit deposit = AdLods.getInstance().features.generator.findDepositBy(name).orElse(null);
        if (deposit != null) {
            BlockPos startPos = context.getBlockPos();
            int amount = (Integer)context.getArgument("amount", Integer.TYPE);
            DepositGenResult result = deposit.generateAt((IServerWorld)context.getWorld(), startPos, amount, true);
            context.sendMessage(result.toString());
        } else {
            context.sendMessage(Commands.depositNotFoundMsg(name));
        }
    }

    public static void reloadConfigs(ServerCommand.Context context) {
        AdLods lods = AdLods.getInstance();
        lods.mainConfigInit();
        lods.features.reload();
        context.sendMessage("Configs reloaded");
    }

    public static void stripChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.stripChunk((World)context.getWorld(), centerPos, AdLods.getInstance().features.generator::isOreBlock);
        context.sendMessage("Chunk at " + centerPos + " stripped");
    }

    public static void stripChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.stripChunksAround((World)context.getWorld(), centerPos, AdLods.getInstance().features.generator::isOreBlock);
        context.sendMessage("Chunks around " + centerPos + " stripped");
    }

    public static void dressChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.dressChunk((World)context.getWorld(), centerPos);
        context.sendMessage("Chunk at " + centerPos + " dressed");
    }

    public static void dressChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.dressChunksAround((World)context.getWorld(), centerPos);
        context.sendMessage("Chunks around " + centerPos + " dressed");
    }

    public static void dressAllChunks(ServerCommand.Context context) {
        Stripper stripper = Stripper.getFor((World)context.getWorld());
        stripper.dressAllChunks((World)context.getWorld());
        context.sendMessage("All stripped chunks dressed");
    }

    static String getDepositName(ServerCommand.Context context) {
        return ((String)context.getArgument("deposit", String.class)).toLowerCase(Locale.ROOT);
    }

    static String depositNotFoundMsg(String name) {
        return "Deposit with name " + CommonString.quoted((String)name) + " not found! Use </lods list> command.";
    }
}

