/*
 * Decompiled with CFR 0.152.
 */
package com.craftsteamg.randomfossils.coremod;

import com.craftsteamg.randomfossils.RandomFossils;
import com.craftsteamg.randomfossils.config.Config;
import com.craftsteamg.randomfossils.config.ConfigManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.Name(value="RandomFossilCore")
@IFMLLoadingPlugin.DependsOn(value={"fossil"})
public class RandomFossilCoreMod
implements IFMLLoadingPlugin {
    private File modFile = null;

    public RandomFossilCoreMod() {
        File file = new File(System.getProperty("user.dir"), "config");
        File configFile = new File(file, "randomfossils.json");
        RandomFossils.configManager = new ConfigManager(configFile);
        Config config = RandomFossils.configManager.load();
        if (config == null) {
            System.out.println("CONFIG IS NULL");
            return;
        }
        try {
            RandomFossils.configManager.setupFossilWeights(config);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        RandomFossils.config = config;
        this.findAndLoadPixelmon();
        MixinBootstrap.init();
        Mixins.addConfiguration((String)"mixins.randomfossils.json");
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> map) {
        this.modFile = (File)map.get("coremodLocation");
        if (this.modFile == null) {
            this.modFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void findAndLoadPixelmon() {
        try {
            File modsFolder = new File(System.getProperty("user.dir"), "mods");
            if (!modsFolder.exists()) {
                // empty if block
            }
            Collection jars = FileUtils.listFiles((File)modsFolder, (String[])new String[]{"jar"}, (boolean)false);
            File pixelmon = null;
            for (File jar : jars) {
                ZipEntry entry;
                ZipInputStream zip = new ZipInputStream(new FileInputStream(jar));
                while ((entry = zip.getNextEntry()) != null) {
                    zip.closeEntry();
                    if (!entry.getName().equals("fossilsarcheology/Revival.class")) continue;
                    pixelmon = jar;
                    break;
                }
                zip.close();
                if (pixelmon == null) continue;
                break;
            }
            if (pixelmon == null) {
                return;
            }
            if (!CoreModManager.getReparseableCoremods().contains(pixelmon.getName())) {
                ((LaunchClassLoader)this.getClass().getClassLoader()).addURL(pixelmon.toURI().toURL());
                CoreModManager.getReparseableCoremods().add(pixelmon.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

