/*
 * Decompiled with CFR 0.152.
 */
package com.craftsteamg.randomfossils.config;

import com.craftsteamg.randomfossils.RandomFossils;
import com.craftsteamg.randomfossils.config.Config;
import com.craftsteamg.randomfossils.config.FossilConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;

public class ConfigManager {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private final File configFile;

    public ConfigManager(File file) {
        this.configFile = file;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.save(new Config());
        }
    }

    public void save(Config config) {
        try (PrintWriter pw = new PrintWriter(this.configFile);){
            pw.print(gson.toJson((Object)config, Config.class));
            pw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Config load() {
        try (FileReader fw = new FileReader(this.configFile);){
            Config config = (Config)gson.fromJson((Reader)fw, Config.class);
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setupFossilWeights(Config config) throws IllegalAccessException {
        RandomFossils.fossilRewardList.clear();
        for (Field f : FossilConfig.class.getDeclaredFields()) {
            for (int i = 0; i < (Integer)f.get(config.fossilConfig); ++i) {
                RandomFossils.fossilRewardList.add(FossilConfig.RewardType.valueOf(f.getName()));
            }
        }
    }
}

