/*
 * Decompiled with CFR 0.152.
 */
package com.craftsteamg.randomfossils;

import com.craftsteamg.randomfossils.config.Config;
import com.craftsteamg.randomfossils.config.ConfigManager;
import com.craftsteamg.randomfossils.config.FossilConfig;
import com.google.inject.Inject;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;

@Plugin(id="randomfossils", name="RandomFossils", description="Change percentages on fossils!", authors={"CraftSteamG"}, dependencies={@Dependency(id="fossil")})
public class RandomFossils {
    public static Config config;
    public static ConfigManager configManager;
    public static Random rng;
    public static List<FossilConfig.RewardType> fossilRewardList;
    @Inject
    private Logger logger;

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        Task.builder().async().execute(() -> {
            if (RandomFossils.config.analyzerConfig.recipes.isEmpty()) {
                RandomFossils.config.analyzerConfig.recipes = RandomFossils.config.analyzerConfig.getDefaultOutputs();
                configManager.save(config);
            }
            FAMachineRecipeRegistry.analyzerRecipes = RandomFossils.config.analyzerConfig.readFromConfig(config);
        }).submit((Object)this);
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        config = configManager.load();
        try {
            configManager.setupFossilWeights(config);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        Task.builder().async().execute(() -> {
            if (RandomFossils.config.analyzerConfig.recipes.isEmpty()) {
                RandomFossils.config.analyzerConfig.recipes = RandomFossils.config.analyzerConfig.getDefaultOutputs();
                configManager.save(config);
            }
            FAMachineRecipeRegistry.analyzerRecipes = RandomFossils.config.analyzerConfig.readFromConfig(config);
        }).submit((Object)this);
    }

    static {
        rng = new Random();
        fossilRewardList = new ArrayList<FossilConfig.RewardType>();
    }
}

