/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.crafting.ingredient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliary;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class IngredientAuxiliaryBasic<A>
implements IngredientAuxiliary<A> {
    protected final ItemStack ingredient;
    protected final boolean isRequired;
    protected final int limit;

    public IngredientAuxiliaryBasic(Item item, boolean isRequired, int limit) {
        this(new ItemStack(Objects.requireNonNull(item, "item")), isRequired, limit);
    }

    public IngredientAuxiliaryBasic(Item item, int metadata, boolean isRequired, int limit) {
        this(new ItemStack(Objects.requireNonNull(item, "item"), 1, metadata), isRequired, limit);
    }

    public IngredientAuxiliaryBasic(Block block, boolean isRequired, int limit) {
        this(new ItemStack(Objects.requireNonNull(block, "block"), 1, Short.MAX_VALUE), isRequired, limit);
    }

    public IngredientAuxiliaryBasic(ItemStack stack, boolean isRequired, int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater than zero");
        this.ingredient = Objects.requireNonNull(stack, "stack");
        this.isRequired = isRequired;
        this.limit = limit;
    }

    @Override
    public final GenericRecipe.MatchResultAuxiliary matches(ItemStack input, ItemStack output) {
        return new GenericRecipe.MatchResultAuxiliary(this, input, OreDictionary.itemMatches((ItemStack)this.ingredient, (ItemStack)input, (boolean)false), Collections.EMPTY_LIST);
    }

    @Override
    public ImmutableList<ItemStack> getInputs() {
        return this.getMatchingSubtypes(this.ingredient);
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

