/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.worldgen;

import com.someguyssoftware.gottschcore.biome.BiomeHelper;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.biome.TreasureBiomeHelper;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Wells;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.well.IWellGenerator;
import com.someguyssoftware.treasure2.generator.well.WellGenerator;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class WellWorldGenerator
implements ITreasureWorldGenerator {
    public static final int CHUNK_RADIUS = 8;
    private int chunksSinceLastWell;
    private IWellGenerator<GeneratorResult<GeneratorData>> generator = new WellGenerator();

    public WellWorldGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to instantiate SurfaceChestGenerator:", (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.chunksSinceLastWell = 0;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList().contains(world.field_73011_w.getDimension())) {
            this.generate(world, random, chunkX, chunkZ);
        }
    }

    private void generate(World world, Random random, int chunkX, int chunkZ) {
        int xSpawn = chunkX * 16 + 8;
        int zSpawn = chunkZ * 16 + 8;
        Coords coords = new Coords(xSpawn, 0, zSpawn);
        Biome biome = world.func_180494_b(coords.toPos());
        if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return;
        }
        ++this.chunksSinceLastWell;
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        if (this.chunksSinceLastWell > TreasureConfig.WELL.chunksPerWell) {
            GenDataPersistence savedData;
            int ySpawn = world.func_72964_e(chunkX, chunkZ).func_76611_b(8, 8);
            coords = new Coords(xSpawn, ySpawn, zSpawn);
            Wells well = Wells.values()[random.nextInt(Wells.values().length)];
            TreasureConfig.Well wellConfig = TreasureConfig.WELL;
            if (wellConfig == null) {
                Treasure.LOGGER.warn("Unable to locate a config for well {}.", (Object)well);
                return;
            }
            if (this.chunksSinceLastWell >= wellConfig.getChunksPerWell()) {
                TreasureBiomeHelper.Result biomeCheck = TreasureBiomeHelper.isBiomeAllowed(biome, wellConfig.getBiomeWhiteList(), wellConfig.getBiomeBlackList());
                if (biomeCheck == TreasureBiomeHelper.Result.BLACK_LISTED) {
                    this.chunksSinceLastWell = 0;
                    return;
                }
                if (biomeCheck == TreasureBiomeHelper.Result.OK && !BiomeHelper.isBiomeAllowed(biome, wellConfig.getBiomeTypeWhiteList(), wellConfig.getBiomeTypeBlackList())) {
                    if (Treasure.LOGGER.isDebugEnabled()) {
                        if (WorldInfo.isClientSide(world)) {
                            Treasure.LOGGER.debug("{} is not a valid biome @ {} for Well", (Object)biome.func_185359_l(), (Object)coords.toShortString());
                        } else {
                            Treasure.LOGGER.debug("Biome is not valid @ {} for Well", (Object)coords.toShortString());
                        }
                    }
                    this.chunksSinceLastWell = 0;
                    return;
                }
                if (!RandomHelper.checkProbability(random, wellConfig.getGenProbability())) {
                    Treasure.LOGGER.debug("Well does not meet generate probability.");
                    return;
                }
                ++this.chunksSinceLastWell;
                Treasure.LOGGER.debug("Attempting to generate a well");
                result = this.generator.generate(world, random, coords, wellConfig);
                Treasure.LOGGER.debug("well world gen result -> {}", (Object)result.isSuccess());
                if (result.isSuccess()) {
                    this.chunksSinceLastWell = 0;
                }
            }
            if ((savedData = GenDataPersistence.get(world)) != null) {
                savedData.func_76185_a();
            }
        }
    }

    private void generateNether(World world, Random random, int i, int j) {
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    public boolean isRegisteredChestWithinDistance(World world, ICoords coords, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<ChestInfo> infos = ChestRegistry.getInstance().getValues();
        if (infos == null || infos.size() == 0) {
            Treasure.LOGGER.debug("Unable to locate the ChestConfig Registry or the Registry doesn't contain any values");
            return false;
        }
        for (ChestInfo info : infos) {
            double distance = coords.getDistanceSq(info.getCoords());
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }

    public int getChunksSinceLastWell() {
        return this.chunksSinceLastWell;
    }

    public void setChunksSinceLastWell(int chunksSinceLastWell) {
        this.chunksSinceLastWell = chunksSinceLastWell;
    }
}

