/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.worldgen;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.someguyssoftware.gottschcore.biome.BiomeHelper;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.biome.TreasureBiomeHelper;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.IChestConfig;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.PitTypes;
import com.someguyssoftware.treasure2.enums.Pits;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.chest.CauldronChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.CommonChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.CrystalSkullChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.EpicChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.GoldSkullChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.LegendaryChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.MythicalChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.RareChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.ScarceChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.SkullChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.UncommonChestGenerator;
import com.someguyssoftware.treasure2.generator.pit.AirPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.BigBottomMobTrapPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.CollapsingTrapPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.IPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.LavaSideTrapPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.LavaTrapPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.MobTrapPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.SimplePitGenerator;
import com.someguyssoftware.treasure2.generator.pit.StructurePitGenerator;
import com.someguyssoftware.treasure2.generator.pit.TntTrapPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.VolcanoPitGenerator;
import com.someguyssoftware.treasure2.generator.ruins.SurfaceRuinGenerator;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class SurfaceChestWorldGenerator
implements ITreasureWorldGenerator {
    protected static int UNDERGROUND_OFFSET = 5;
    private int chunksSinceLastChest;
    private Map<Rarity, Integer> chunksSinceLastRarityChest;
    private Map<Rarity, RandomWeightedCollection<IChestGenerator>> chestGenMap = new HashMap<Rarity, RandomWeightedCollection<IChestGenerator>>();
    public static Table<PitTypes, Pits, IPitGenerator<GeneratorResult<ChestGeneratorData>>> pitGens = HashBasedTable.create();
    public static final List<Rarity> RARITIES = new ArrayList<Rarity>();

    public SurfaceChestWorldGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to instantiate SurfaceChestGenerator:", (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.chunksSinceLastChest = 0;
        this.chunksSinceLastRarityChest = new HashMap<Rarity, Integer>(Rarity.values().length);
        for (Rarity rarity : Rarity.values()) {
            this.chunksSinceLastRarityChest.put(rarity, 0);
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.COMMON).isEnableChest()) {
            RARITIES.add(Rarity.COMMON);
            this.chestGenMap.put(Rarity.COMMON, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.COMMON).add(1, new CommonChestGenerator());
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.UNCOMMON).isEnableChest()) {
            RARITIES.add(Rarity.UNCOMMON);
            this.chestGenMap.put(Rarity.UNCOMMON, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.UNCOMMON).add(1, new UncommonChestGenerator());
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.SCARCE).isEnableChest()) {
            RARITIES.add(Rarity.SCARCE);
            this.chestGenMap.put(Rarity.SCARCE, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.SCARCE).add(75, new ScarceChestGenerator());
            this.chestGenMap.get(Rarity.SCARCE).add(25, new SkullChestGenerator());
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.RARE).isEnableChest()) {
            RARITIES.add(Rarity.RARE);
            this.chestGenMap.put(Rarity.RARE, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.RARE).add(85, new RareChestGenerator());
            this.chestGenMap.get(Rarity.RARE).add(15, new GoldSkullChestGenerator());
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.EPIC).isEnableChest()) {
            RARITIES.add(Rarity.EPIC);
            this.chestGenMap.put(Rarity.EPIC, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.EPIC).add(70, new EpicChestGenerator());
            this.chestGenMap.get(Rarity.EPIC).add(15, new CauldronChestGenerator());
            this.chestGenMap.get(Rarity.EPIC).add(15, new CrystalSkullChestGenerator());
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.LEGENDARY).isEnableChest()) {
            RARITIES.add(Rarity.LEGENDARY);
            this.chestGenMap.put(Rarity.LEGENDARY, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.LEGENDARY).add(1, new LegendaryChestGenerator());
        }
        if (TreasureConfig.CHESTS.surfaceChests.configMap.get(Rarity.MYTHICAL).isEnableChest()) {
            RARITIES.add(Rarity.MYTHICAL);
            this.chestGenMap.put(Rarity.MYTHICAL, new RandomWeightedCollection());
            this.chestGenMap.get(Rarity.MYTHICAL).add(1, new MythicalChestGenerator());
        }
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.SIMPLE_PIT, (Object)new SimplePitGenerator());
        pitGens.put((Object)PitTypes.STRUCTURE, (Object)Pits.SIMPLE_PIT, (Object)new StructurePitGenerator(new SimplePitGenerator()));
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.TNT_TRAP_PIT, (Object)new TntTrapPitGenerator());
        pitGens.put((Object)PitTypes.STRUCTURE, (Object)Pits.TNT_TRAP_PIT, (Object)new StructurePitGenerator(new TntTrapPitGenerator()));
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.AIR_PIT, (Object)new AirPitGenerator());
        pitGens.put((Object)PitTypes.STRUCTURE, (Object)Pits.AIR_PIT, (Object)new StructurePitGenerator(new AirPitGenerator()));
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.LAVA_TRAP_PIT, (Object)new LavaTrapPitGenerator());
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.MOB_TRAP_PIT, (Object)new MobTrapPitGenerator());
        pitGens.put((Object)PitTypes.STRUCTURE, (Object)Pits.MOB_TRAP_PIT, (Object)new StructurePitGenerator(new MobTrapPitGenerator()));
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.LAVA_SIDE_TRAP_PIT, (Object)new LavaSideTrapPitGenerator());
        pitGens.put((Object)PitTypes.STRUCTURE, (Object)Pits.LAVA_SIDE_TRAP_PIT, (Object)new StructurePitGenerator(new LavaSideTrapPitGenerator()));
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.BIG_BOTTOM_MOB_TRAP_PIT, (Object)new BigBottomMobTrapPitGenerator());
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.COLLAPSING_TRAP_PIT, (Object)new CollapsingTrapPitGenerator());
        pitGens.put((Object)PitTypes.STRUCTURE, (Object)Pits.COLLAPSING_TRAP_PIT, (Object)new StructurePitGenerator(new CollapsingTrapPitGenerator()));
        pitGens.put((Object)PitTypes.STANDARD, (Object)Pits.VOLCANO_PIT, (Object)new VolcanoPitGenerator());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList().contains(world.field_73011_w.getDimension())) {
            this.generate(world, random, chunkX, chunkZ);
        }
    }

    private void generate(World world, Random random, int chunkX, int chunkZ) {
        int xSpawn = chunkX * 16 + 8;
        int zSpawn = chunkZ * 16 + 8;
        Coords coords = new Coords(xSpawn, 0, zSpawn);
        Biome biome = world.func_180494_b(coords.toPos());
        if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return;
        }
        ++this.chunksSinceLastChest;
        for (Rarity rarity : RARITIES) {
            Integer i = this.chunksSinceLastRarityChest.get(rarity);
            i = i + 1;
            this.chunksSinceLastRarityChest.put(rarity, i);
        }
        if (this.chunksSinceLastChest > TreasureConfig.CHESTS.surfaceChests.minChunksPerChest) {
            GenDataPersistence savedData;
            Rarity rarity;
            int ySpawn = world.func_72964_e(chunkX, chunkZ).func_76611_b(8, 8);
            coords = new Coords(xSpawn, ySpawn, zSpawn);
            rarity = RARITIES.get(random.nextInt(RARITIES.size()));
            IChestConfig chestConfig = TreasureConfig.CHESTS.surfaceChests.configMap.get(rarity);
            if (chestConfig == null) {
                Treasure.LOGGER.warn("Unable to locate a chest for rarity {}.", (Object)rarity);
                return;
            }
            if (this.chunksSinceLastRarityChest.get(rarity) >= chestConfig.getChunksPerChest()) {
                if (!RandomHelper.checkProbability(random, chestConfig.getGenProbability())) {
                    return;
                }
                TreasureBiomeHelper.Result biomeCheck = TreasureBiomeHelper.isBiomeAllowed(biome, chestConfig.getBiomeWhiteList(), chestConfig.getBiomeBlackList());
                if (biomeCheck == TreasureBiomeHelper.Result.BLACK_LISTED) {
                    if (WorldInfo.isClientSide(world)) {
                        Treasure.LOGGER.debug("{} is not a valid biome @ {}", (Object)biome.func_185359_l(), (Object)coords.toShortString());
                    } else {
                        Treasure.LOGGER.debug("Biome {} is not valid @ {}", (Object)rarity.getValue(), (Object)coords.toShortString());
                    }
                    return;
                }
                if (biomeCheck == TreasureBiomeHelper.Result.OK && !BiomeHelper.isBiomeAllowed(biome, chestConfig.getBiomeTypeWhiteList(), chestConfig.getBiomeTypeBlackList())) {
                    if (Treasure.LOGGER.isDebugEnabled()) {
                        if (WorldInfo.isClientSide(world)) {
                            Treasure.LOGGER.debug("{} is not a valid biome type @ {}", (Object)biome.func_185359_l(), (Object)coords.toShortString());
                        } else {
                            Treasure.LOGGER.debug("Biome type of {} is not valid @ {}", (Object)rarity.getValue(), (Object)coords.toShortString());
                        }
                    }
                    return;
                }
                if (this.isRegisteredChestWithinDistance(world, coords, TreasureConfig.CHESTS.surfaceChests.minDistancePerChest)) {
                    return;
                }
                this.chunksSinceLastRarityChest.put(rarity, 0);
                Treasure.LOGGER.debug("Attempting to generate pit/chest.");
                GeneratorResult<GeneratorData> result = null;
                result = this.generate(world, random, coords, rarity, this.chestGenMap.get(rarity).next(), TreasureConfig.CHESTS.surfaceChests.configMap.get(rarity));
                if (result.isSuccess()) {
                    ChestRegistry.getInstance().register(coords.toShortString(), new ChestInfo(rarity, coords));
                    this.chunksSinceLastChest = 0;
                }
            }
            if ((savedData = GenDataPersistence.get(world)) != null) {
                savedData.func_76185_a();
            }
        }
    }

    private GeneratorResult<GeneratorData> generate(World world, Random random, ICoords coords, Rarity chestRarity, IChestGenerator chestGenerator, IChestConfig config) {
        ICoords chestCoords = null;
        ICoords markerCoords = null;
        boolean hasMarkers = true;
        boolean isSurfaceChest = false;
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        GeneratorResult<ChestGeneratorData> genResult = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        ICoords surfaceCoords = WorldInfo.getDryLandSurfaceCoords(world, coords);
        Treasure.LOGGER.debug("surface coords -> {}", (Object)surfaceCoords.toShortString());
        if (!WorldInfo.isValidY(surfaceCoords)) {
            Treasure.LOGGER.debug("surface coords are invalid @ {}", (Object)surfaceCoords.toShortString());
            return result.fail();
        }
        markerCoords = surfaceCoords;
        if (config.isSurfaceAllowed() && RandomHelper.checkProbability(random, TreasureConfig.CHESTS.surfaceChests.surfaceChestProbability)) {
            isSurfaceChest = true;
            if (RandomHelper.checkProbability(random, TreasureConfig.WORLD_GEN.getGeneralProperties().surfaceStructureProbability)) {
                hasMarkers = false;
                genResult = this.generateSurfaceRuins(world, random, surfaceCoords, config);
                Treasure.LOGGER.debug("surface result -> {}", (Object)genResult.toString());
                if (!genResult.isSuccess()) {
                    return result.fail();
                }
                chestCoords = genResult.getData().getChestContext().getCoords();
            } else {
                chestCoords = new Coords(markerCoords);
            }
        } else if (config.isSubterraneanAllowed()) {
            Treasure.LOGGER.debug("else generate pit");
            genResult = SurfaceChestWorldGenerator.generatePit(world, random, chestRarity, markerCoords, config);
            Treasure.LOGGER.debug("result -> {}", (Object)genResult.toString());
            if (!genResult.isSuccess()) {
                return result.fail();
            }
            chestCoords = genResult.getData().getChestContext().getCoords();
        }
        if (chestCoords == null) {
            Treasure.LOGGER.debug("Chest coords were not provided in result -> {}", (Object)genResult.toString());
            return result.fail();
        }
        GeneratorResult<ChestGeneratorData> chestResult = chestGenerator.generate(world, random, chestCoords, chestRarity, genResult.getData().getChestContext().getState());
        if (!chestResult.isSuccess()) {
            return result.fail();
        }
        if (hasMarkers) {
            chestGenerator.addMarkers(world, random, markerCoords, isSurfaceChest);
        }
        Treasure.LOGGER.info("CHEATER! {} chest at coords: {}", (Object)chestRarity, (Object)markerCoords.toShortString());
        result.setData(chestResult.getData());
        return result.success();
    }

    public GeneratorResult<ChestGeneratorData> generateSurfaceRuins(World world, Random random, ICoords spawnCoords, IChestConfig config) {
        return this.generateSurfaceRuins(world, random, spawnCoords, null, null, config);
    }

    public GeneratorResult<ChestGeneratorData> generateSurfaceRuins(World world, Random random, ICoords spawnCoords, TemplateHolder holder, IDecayRuleSet decayRuleSet, IChestConfig config) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        result.getData().setSpawnCoords(spawnCoords);
        SurfaceRuinGenerator generator = new SurfaceRuinGenerator();
        GeneratorResult<ChestGeneratorData> genResult = generator.generate(world, random, spawnCoords, holder, decayRuleSet);
        Treasure.LOGGER.debug("surface struct result -> {}", genResult);
        if (!genResult.isSuccess()) {
            return result.fail();
        }
        result.setData(genResult.getData());
        return result.success();
    }

    public static GeneratorResult<ChestGeneratorData> generatePit(World world, Random random, Rarity chestRarity, ICoords markerCoords, IChestConfig config) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        GeneratorResult<ChestGeneratorData> pitResult = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        if (!WorldInfo.isSolidBase(world, markerCoords, 2, 2, 50.0)) {
            Treasure.LOGGER.debug("Coords [{}] does not meet solid base requires for {} x {}", (Object)markerCoords.toShortString(), (Object)3, (Object)3);
            return result.fail();
        }
        ICoords spawnCoords = SurfaceChestWorldGenerator.getUndergroundSpawnPos(world, random, markerCoords, config.getMinDepth(), config.getMaxDepth());
        if (spawnCoords == null || spawnCoords == WorldInfo.EMPTY_COORDS) {
            Treasure.LOGGER.debug("Unable to spawn underground @ {}", (Object)markerCoords);
            return result.fail();
        }
        Treasure.LOGGER.debug("Below ground @ {}", (Object)spawnCoords.toShortString());
        result.getData().setSpawnCoords(markerCoords);
        IPitGenerator<GeneratorResult<ChestGeneratorData>> pitGenerator = SurfaceChestWorldGenerator.selectPitGenerator(random);
        Treasure.LOGGER.debug("Using pit generator -> {}", (Object)pitGenerator.getClass().getSimpleName());
        pitResult = pitGenerator.generate(world, random, markerCoords, spawnCoords);
        if (!pitResult.isSuccess()) {
            return result.fail();
        }
        result.setData(pitResult.getData());
        Treasure.LOGGER.debug("Is pit generated: {}", (Object)pitResult.isSuccess());
        return result.success();
    }

    public static IPitGenerator<GeneratorResult<ChestGeneratorData>> selectPitGenerator(Random random) {
        PitTypes pitType = RandomHelper.checkProbability(random, TreasureConfig.PIT.pitStructureProbability) ? PitTypes.STRUCTURE : PitTypes.STANDARD;
        List pitGenerators = pitGens.row((Object)pitType).values().stream().collect(Collectors.toList());
        IPitGenerator pitGenerator = (IPitGenerator)pitGenerators.get(random.nextInt(pitGenerators.size()));
        Treasure.LOGGER.debug("Using PitType: {}, Gen: {}", (Object)pitType, (Object)pitGenerator.getClass().getSimpleName());
        return pitGenerator;
    }

    @Deprecated
    public static ICoords getUndergroundSpawnPos(World world, Random random, ICoords pos, int spawnYMin) {
        ICoords spawnPos = null;
        if (pos.getY() > spawnYMin + UNDERGROUND_OFFSET) {
            int ySpawn = random.nextInt(pos.getY() - (spawnYMin + UNDERGROUND_OFFSET)) + spawnYMin;
            spawnPos = new Coords(pos.getX(), ySpawn, pos.getZ());
            spawnPos = WorldInfo.getDryLandSurfaceCoords(world, spawnPos);
        }
        return spawnPos;
    }

    public static ICoords getUndergroundSpawnPos(World world, Random random, ICoords pos, int minDepth, int maxDepth) {
        ICoords spawnPos = null;
        int depth = RandomHelper.randomInt(minDepth, maxDepth);
        int ySpawn = Math.max(UNDERGROUND_OFFSET, pos.getY() - depth);
        Treasure.LOGGER.debug("ySpawn -> {}", (Object)ySpawn);
        spawnPos = new Coords(pos.getX(), ySpawn, pos.getZ());
        spawnPos = WorldInfo.getDryLandSurfaceCoords(world, spawnPos);
        return spawnPos;
    }

    private void generateNether(World world, Random random, int i, int j) {
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    public boolean isRegisteredChestWithinDistance(World world, ICoords coords, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<ChestInfo> infos = ChestRegistry.getInstance().getValues();
        if (infos == null || infos.size() == 0) {
            Treasure.LOGGER.debug("Unable to locate the ChestConfig Registry or the Registry doesn't contain any values");
            return false;
        }
        for (ChestInfo info : infos) {
            double distance = coords.getDistanceSq(info.getCoords());
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }

    public int getChunksSinceLastChest() {
        return this.chunksSinceLastChest;
    }

    public void setChunksSinceLastChest(int chunksSinceLastChest) {
        this.chunksSinceLastChest = chunksSinceLastChest;
    }

    public Map<Rarity, Integer> getChunksSinceLastRarityChest() {
        return this.chunksSinceLastRarityChest;
    }

    public void setChunksSinceLastRarityChest(Map<Rarity, Integer> chunksSinceLastRarityChest) {
        this.chunksSinceLastRarityChest = chunksSinceLastRarityChest;
    }

    public Map<Rarity, RandomWeightedCollection<IChestGenerator>> getChestGenMap() {
        return this.chestGenMap;
    }

    public void setChestGenMap(Map<Rarity, RandomWeightedCollection<IChestGenerator>> chestGenMap) {
        this.chestGenMap = chestGenMap;
    }

    public static Table<PitTypes, Pits, IPitGenerator<GeneratorResult<ChestGeneratorData>>> getPitGens() {
        return pitGens;
    }

    public static void setPitGens(Table<PitTypes, Pits, IPitGenerator<GeneratorResult<ChestGeneratorData>>> pitGens) {
        SurfaceChestWorldGenerator.pitGens = pitGens;
    }
}

