/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.world.gen.structure;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayRuleSet;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.treasure2.Treasure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public class TreasureDecayManager {
    protected static final Gson GSON_INSTANCE = new GsonBuilder().create();
    private final Map<String, IDecayRuleSet> ruleSetMap = Maps.newHashMap();
    private File worldSaveFolder;

    public void clear() {
        this.getRuleSetMap().clear();
    }

    public void register(String modID, List<String> resourcePaths) {
        Treasure.LOGGER.debug("registering decay resources");
        this.createDecayFolder(modID);
        Treasure.LOGGER.debug("created decay folder");
        List<ResourceLocation> resourceLocations = this.getResourceLocations(modID, resourcePaths);
        Treasure.LOGGER.debug("acquired resource locations -> {}", resourceLocations);
        resourceLocations.forEach(loc -> {
            Treasure.LOGGER.debug("register decay -> loading decay resource loc -> {}", (Object)loc.toString());
            this.tableDecay((ResourceLocation)loc, this.load((ResourceLocation)loc));
        });
    }

    private void createDecayFolder(String modID) {
        Path folder = Paths.get(this.getWorldSaveFolder().getPath(), "data/decay", modID, "rulesets").toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            Treasure.LOGGER.debug("decay folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                Treasure.LOGGER.warn("Unable to create decay folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    public List<ResourceLocation> getResourceLocations(String modID, List<String> resources) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        resources.forEach(resource -> resourceLocations.add(new ResourceLocation(modID, resource)));
        return resourceLocations;
    }

    public Optional<IDecayRuleSet> load(ResourceLocation resource) {
        Optional<IDecayRuleSet> decay = this.loadFromWorldSave(this.getWorldSaveFolder(), resource);
        if (!decay.isPresent()) {
            return this.loadFromJar(resource);
        }
        return decay;
    }

    private Optional<IDecayRuleSet> loadFromJar(ResourceLocation resource) {
        Optional<IDecayRuleSet> resourceMeta = Optional.empty();
        String relativePath = "decay/" + resource.func_110624_b() + "/" + resource.func_110623_a();
        Treasure.LOGGER.debug("Attempting to load decay {} from jar -> {}", (Object)resource, (Object)relativePath);
        try (InputStream resourceStream = Treasure.instance.getClass().getClassLoader().getResourceAsStream(relativePath);
             InputStreamReader reader = new InputStreamReader(resourceStream, StandardCharsets.UTF_8);){
            resourceMeta = Optional.of(this.load(reader));
        }
        catch (Exception e) {
            Treasure.LOGGER.error(String.format("Couldn't load resource meta %s ", relativePath), (Throwable)e);
        }
        return resourceMeta;
    }

    private Optional<IDecayRuleSet> loadFromWorldSave(File folder, ResourceLocation resource) {
        if (folder == null) {
            return Optional.empty();
        }
        File metaFile = Paths.get(folder.getPath(), "data", "decay", resource.func_110624_b(), resource.func_110623_a()).toFile();
        Treasure.LOGGER.debug("Attempting to load decay {} from {}", (Object)resource, (Object)metaFile);
        if (metaFile.exists()) {
            if (metaFile.isFile()) {
                String json;
                try {
                    json = com.google.common.io.Files.toString((File)metaFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    Treasure.LOGGER.warn("Couldn't load decay {} from {}", (Object)resource, (Object)metaFile, (Object)e);
                    return Optional.empty();
                }
                try {
                    return Optional.of(this.load(json));
                }
                catch (JsonParseException | IllegalArgumentException e) {
                    Treasure.LOGGER.error("Couldn't load meta {} from {}", (Object)resource, (Object)metaFile, (Object)e);
                    return Optional.empty();
                }
            }
            Treasure.LOGGER.warn("Expected to find meta {} at {} but it was a folder.", (Object)resource, (Object)metaFile);
            return Optional.empty();
        }
        Treasure.LOGGER.warn("Expected to find meta {} at {} but it doesn't exist.", (Object)resource, (Object)metaFile);
        return Optional.empty();
    }

    public IDecayRuleSet load(Reader reader) {
        return (IDecayRuleSet)GSON_INSTANCE.fromJson(reader, DecayRuleSet.class);
    }

    public IDecayRuleSet load(String json) throws IllegalArgumentException, JsonParseException {
        return (IDecayRuleSet)GSON_INSTANCE.fromJson(json, DecayRuleSet.class);
    }

    private void tableDecay(ResourceLocation resourceLocation, Optional<IDecayRuleSet> decay) {
        if (decay.isPresent()) {
            Treasure.LOGGER.debug("tabling meta: key -> {}, meta -> {}", (Object)resourceLocation.toString(), decay);
            this.getRuleSetMap().put(resourceLocation.toString(), decay.get());
        } else {
            Treasure.LOGGER.debug("unable to table meta from -> {}", (Object)resourceLocation);
        }
    }

    public File getWorldSaveFolder() {
        return this.worldSaveFolder;
    }

    public void setWorldSaveFolder(File worldSaveFolder) {
        this.worldSaveFolder = worldSaveFolder;
    }

    public Map<String, IDecayRuleSet> getRuleSetMap() {
        return this.ruleSetMap;
    }
}

