/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.world.gen.structure;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockContext;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplate;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayProcessor;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.registry.TreasureMetaRegistry;
import com.someguyssoftware.treasure2.registry.TreasureTemplateRegistry;
import com.someguyssoftware.treasure2.world.gen.structure.ITemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class TemplateGenerator
implements ITemplateGenerator<GeneratorResult<TemplateGeneratorData>> {
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyEnum<EnumFacing> CHEST_FACING = PropertyDirection.func_177709_a((String)"facing", EnumFacing.class);
    private Block nullBlock;

    public TemplateGenerator() {
        this.setNullBlock(GenUtil.getMarkerBlock(StructureMarkers.NULL));
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, TemplateHolder templateHolder, PlacementSettings placement, ICoords coords) {
        return this.generate(world, random, null, templateHolder, placement, coords);
    }

    @Override
    public GeneratorResult<TemplateGeneratorData> generate(World world, Random random, IDecayProcessor decayProcessor, TemplateHolder templateHolder, PlacementSettings placement, ICoords coords) {
        GeneratorResult<TemplateGeneratorData> result = new GeneratorResult<TemplateGeneratorData>(TemplateGeneratorData.class);
        GottschTemplate template = (GottschTemplate)templateHolder.getTemplate();
        Treasure.LOGGER.debug("template size -> {}", (Object)template.func_186259_a());
        StructureMeta meta = TreasureMetaRegistry.get(templateHolder.getMetaLocation().toString());
        if (meta == null) {
            Treasure.LOGGER.debug("Unable to locate meta data for template -> {}", (Object)templateHolder.getLocation());
            return result.fail();
        }
        Treasure.LOGGER.debug("meta -> {}", (Object)meta);
        if (meta.getNullBlockName() != null && !meta.getNullBlockName().equals("")) {
            Treasure.LOGGER.debug("setting the null block to -> {}", (Object)meta.getNullBlockName());
            this.setNullBlock(Block.func_149684_b((String)meta.getNullBlockName()));
        }
        int offset = 0;
        ICoords offsetCoords = null;
        if (meta.getOffset() != null) {
            offsetCoords = new Coords(0, -meta.getOffset().getY(), 0);
            Treasure.LOGGER.debug("Using meta offset coords -> {}", (Object)offsetCoords);
        } else {
            offsetCoords = template.findCoords(random, GenUtil.getMarkerBlock(StructureMarkers.OFFSET));
        }
        if (offsetCoords != null) {
            offset = -offsetCoords.getY();
        }
        ICoords spawnCoords = coords.add(0, offset, 0);
        if (decayProcessor == null) {
            Treasure.LOGGER.debug("no decay processor found.");
            template.addBlocksToWorld(world, spawnCoords.toPos(), placement, this.getNullBlock(), TreasureTemplateRegistry.getManager().getReplacementMap(), 3);
        } else {
            decayProcessor.setDecayStartY(Math.abs(offset));
            template.addBlocksToWorld(world, spawnCoords.toPos(), decayProcessor, placement, this.getNullBlock(), TreasureTemplateRegistry.getManager().getReplacementMap(), 3);
        }
        for (Map.Entry entry : template.getTagBlockMap().entries()) {
            BlockContext context = this.getAbsoluteTransformedContext((BlockContext)entry.getValue(), spawnCoords, placement);
            result.getData().getMap().put(entry.getKey(), (Object)context);
            Treasure.LOGGER.debug("new: adding to structure info absoluted transformed coords -> {} : {}", (Object)((Block)entry.getKey()).func_149732_F(), (Object)context.getCoords().toShortString());
        }
        BlockPos transformedSize = template.func_186257_a(placement.func_186215_c());
        spawnCoords = this.getTransformedSpawnCoords(spawnCoords, new Coords(transformedSize), placement).add(0, -offset, 0);
        Treasure.LOGGER.debug("spawn coords after rotation -> " + spawnCoords);
        result.getData().setSpawnCoords(spawnCoords);
        result.getData().setSize(new Coords(transformedSize));
        return result.success();
    }

    private BlockContext getAbsoluteTransformedContext(BlockContext contextIn, ICoords spawnCoords, PlacementSettings placement) {
        BlockContext context = new BlockContext();
        ICoords coords = new Coords(GottschTemplate.transformedCoords(placement, contextIn.getCoords()));
        coords = spawnCoords.add(coords);
        context.setCoords(coords);
        IBlockState chestState = contextIn.getState();
        chestState = chestState.func_185902_a(placement.func_186212_b());
        chestState = chestState.func_185907_a(placement.func_186215_c());
        if (chestState.func_177228_b().containsKey((Object)FACING)) {
            IBlockState modState = TreasureBlocks.WOOD_CHEST.func_176223_P().func_177226_a(CHEST_FACING, (Comparable)((EnumFacing)chestState.func_177228_b().get((Object)FACING)));
            context.setState(modState);
        } else {
            context.setState(contextIn.getState());
        }
        return context;
    }

    public ICoords getTransformedSpawnCoords(ICoords coords, ICoords size, PlacementSettings placement) {
        Coords spawnCoords = null;
        int x = 0;
        int z = 0;
        switch (placement.func_186215_c()) {
            case NONE: {
                x = coords.getX();
                z = coords.getZ();
                break;
            }
            case CLOCKWISE_90: {
                x = coords.getX() - (size.getZ() - 1);
                z = coords.getZ();
                break;
            }
            case CLOCKWISE_180: {
                x = coords.getX() - (size.getX() - 1);
                z = coords.getZ() - (size.getZ() - 1);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                x = coords.getX();
                z = coords.getZ() - (size.getX() - 1);
                break;
            }
        }
        spawnCoords = new Coords(x, coords.getY(), z);
        return spawnCoords;
    }

    @Override
    public Block getNullBlock() {
        if (this.nullBlock == null) {
            this.nullBlock = GenUtil.getMarkerBlock(StructureMarkers.NULL);
        }
        return this.nullBlock;
    }

    @Override
    public void setNullBlock(Block nullBlock) {
        this.nullBlock = nullBlock;
    }
}

