/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.IlluminationCharm;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.rune.AngelsRune;
import com.someguyssoftware.treasure2.rune.AnvilRune;
import com.someguyssoftware.treasure2.rune.DoubleChargeRune;
import com.someguyssoftware.treasure2.rune.DurabilityRune;
import com.someguyssoftware.treasure2.rune.EquipmentManaRune;
import com.someguyssoftware.treasure2.rune.GreaterManaRune;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.ManaRune;
import com.someguyssoftware.treasure2.rune.PersistenceRune;
import com.someguyssoftware.treasure2.rune.QualityRune;
import com.someguyssoftware.treasure2.rune.SocketsRune;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class TreasureRunes {
    private static final Map<ResourceLocation, IRune> REGISTRY = new HashMap<ResourceLocation, IRune>();
    private static final Multimap<Rarity, IRune> RARITY_REGISTRY = ArrayListMultimap.create();
    private static final Map<IRune, Item> ITEM_REGISTRY = new HashMap<IRune, Item>();
    public static IRune RUNE_OF_MANA = new ManaRune.Builder(ResourceLocationUtil.create("mana_rune")).with($ -> {
        $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.mana_rune");
        $.rarity = Rarity.SCARCE;
        $.getInvalids().add(IlluminationCharm.ILLUMINATION_TYPE);
    }).build();
    public static IRune RUNE_OF_GREATER_MANA;
    public static IRune RUNE_OF_DURABILITY;
    public static IRune RUNE_OF_QUALITY;
    public static IRune RUNE_OF_ANGELS;
    public static IRune RUNE_OF_ANVIL;
    public static IRune RUNE_OF_EQUIP_AS_MANA;
    public static IRune RUNE_OF_PERSISTENCE;
    public static IRune RUNE_OF_SOCKETS;
    public static IRune RUNE_OF_DOUBLE_CHARGE;

    public static void register(IRune runestone) {
        Treasure.LOGGER.debug("registering runestone -> {}", (Object)runestone.getName());
        if (!REGISTRY.containsKey(runestone.getName())) {
            REGISTRY.put(runestone.getName(), runestone);
        }
        if (!RARITY_REGISTRY.containsValue((Object)runestone)) {
            RARITY_REGISTRY.put((Object)runestone.getRarity(), (Object)runestone);
        }
    }

    public static Optional<IRune> get(ResourceLocation name) {
        if (REGISTRY.containsKey(name)) {
            return Optional.of(REGISTRY.get(name));
        }
        return Optional.empty();
    }

    public static List<IRune> getByRarity(Rarity rarity) {
        return (List)RARITY_REGISTRY.get((Object)rarity);
    }

    public static List<IRune> values() {
        return (List)REGISTRY.values();
    }

    public static void register(IRune runestone, Item item) {
        Treasure.LOGGER.debug("registering runestone -> {} to item -> {}", (Object)runestone.getName(), (Object)item.getRegistryName());
        if (!ITEM_REGISTRY.containsKey(runestone)) {
            ITEM_REGISTRY.put(runestone, item);
        }
    }

    public static Optional<Item> getItem(IRune runestone) {
        return Optional.ofNullable(ITEM_REGISTRY.get(runestone));
    }

    public static List<Item> itemValues() {
        return new ArrayList<Item>(ITEM_REGISTRY.values());
    }

    static {
        TreasureRunes.register(RUNE_OF_MANA);
        RUNE_OF_GREATER_MANA = new GreaterManaRune.Builder(ResourceLocationUtil.create("greater_mana_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.greater_mana_rune");
            $.rarity = Rarity.RARE;
            $.getInvalids().add(IlluminationCharm.ILLUMINATION_TYPE);
        }).build();
        TreasureRunes.register(RUNE_OF_GREATER_MANA);
        RUNE_OF_DURABILITY = new DurabilityRune.Builder(ResourceLocationUtil.create("durability_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.durability_rune");
            $.rarity = Rarity.SCARCE;
        }).build();
        TreasureRunes.register(RUNE_OF_DURABILITY);
        RUNE_OF_QUALITY = new QualityRune.Builder(ResourceLocationUtil.create("quality_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.quality_rune");
            $.rarity = Rarity.RARE;
            $.getInvalids().add(IlluminationCharm.ILLUMINATION_TYPE);
        }).build();
        TreasureRunes.register(RUNE_OF_QUALITY);
        RUNE_OF_EQUIP_AS_MANA = new EquipmentManaRune.Builder(ResourceLocationUtil.create("equip_mana_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.equip_mana_rune");
            $.rarity = Rarity.RARE;
        }).build();
        TreasureRunes.register(RUNE_OF_EQUIP_AS_MANA);
        RUNE_OF_ANVIL = new AnvilRune.Builder(ResourceLocationUtil.create("anvil_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.anvil_rune");
            $.rarity = Rarity.EPIC;
        }).build();
        TreasureRunes.register(RUNE_OF_ANVIL);
        RUNE_OF_ANGELS = new AngelsRune.Builder(ResourceLocationUtil.create("angels_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.angels_rune");
            $.rarity = Rarity.LEGENDARY;
        }).build();
        TreasureRunes.register(RUNE_OF_ANGELS);
        RUNE_OF_PERSISTENCE = new PersistenceRune.Builder(ResourceLocationUtil.create("persistence_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.persistence_rune");
            $.rarity = Rarity.EPIC;
        }).build();
        TreasureRunes.register(RUNE_OF_PERSISTENCE);
        RUNE_OF_SOCKETS = new SocketsRune.Builder(ResourceLocationUtil.create("sockets_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.sockets_rune");
            $.rarity = Rarity.RARE;
        }).build();
        TreasureRunes.register(RUNE_OF_SOCKETS);
        RUNE_OF_DOUBLE_CHARGE = new DoubleChargeRune.Builder(ResourceLocationUtil.create("double_charge_rune")).with($ -> {
            $.lore = I18n.func_74838_a((String)"tooltip.runestone.lore.double_charge_rune");
            $.rarity = Rarity.MYTHICAL;
        }).build();
        TreasureRunes.register(RUNE_OF_DOUBLE_CHARGE);
    }
}

