/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.RuneEntity;
import com.someguyssoftware.treasure2.rune.TreasureRunes;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public abstract class Rune
implements IRune {
    private ResourceLocation name;
    private String type;
    private String lore;
    private Rarity rarity;
    private List<String> invalids;

    protected Rune(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.lore = builder.lore;
        this.rarity = builder.rarity;
        this.invalids = builder.invalids;
    }

    @Override
    public IRuneEntity createEntity() {
        RuneEntity entity = new RuneEntity();
        entity.setRunestone(this);
        return entity;
    }

    public IRuneEntity createEntity(IRuneEntity entity) {
        RuneEntity newEntity = new RuneEntity(entity);
        return newEntity;
    }

    @Override
    public abstract boolean isValid(ItemStack var1);

    @Override
    public abstract void apply(ItemStack var1, IRuneEntity var2);

    @Override
    public abstract void undo(ItemStack var1, IRuneEntity var2);

    @Override
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag, IRuneEntity entity) {
        TextFormatting color = TextFormatting.LIGHT_PURPLE;
        tooltip.add(color + "" + I18n.func_74837_a((String)"tooltip.indent2", (Object[])new Object[]{I18n.func_74838_a((String)("runestone." + this.getName().toString() + ".name"))}));
    }

    public static Optional<IRune> load(NBTTagCompound tag) {
        Optional<IRune> runestone = Optional.empty();
        try {
            String name = tag.func_74779_i("name");
            ResourceLocation resource = ResourceLocationUtil.create(name);
            runestone = TreasureRunes.get(resource);
            if (!runestone.isPresent()) {
                throw new Exception(String.format("Unable to locate charm %s in registry.", resource.toString()));
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to read state to NBT:", (Throwable)e);
        }
        return runestone;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        try {
            nbt.func_74778_a("name", this.name.toString());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public String getLore() {
        return this.lore;
    }

    @Override
    public void setLore(String lore) {
        this.lore = lore;
    }

    public String toString() {
        return "Runestone [name=" + this.name + ", type=" + this.type + ", lore=" + this.lore + ", rarity=" + this.rarity + "]";
    }

    public List<String> getInvalids() {
        if (this.invalids == null) {
            this.invalids = new ArrayList<String>();
        }
        return this.invalids;
    }

    public static abstract class Builder {
        private final ResourceLocation name;
        private String type;
        public String lore;
        public Rarity rarity;
        private List<String> invalids;

        public Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder with(Consumer<Builder> builder) {
            builder.accept(this);
            return this;
        }

        public abstract IRune build();

        public List<String> getInvalids() {
            if (this.invalids == null) {
                this.invalids = new ArrayList<String>();
            }
            return this.invalids;
        }
    }
}

