/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ManaRune
extends Rune {
    protected ManaRune(Builder builder) {
        super(builder);
    }

    protected ManaRune(Rune.Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null);
    }

    public void initCapabilityApply(ICharmableCapability capability, IRuneEntity entity) {
        this.process(capability, entity);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        if (!this.isValid(itemStack)) {
            return;
        }
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        this.process(cap, entity);
    }

    protected void process(ICharmableCapability cap, IRuneEntity entity) {
        cap.getCharmEntities().forEach((key, value) -> {
            if (!entity.isAppliedTo(value.getCharm().getType()) && !this.getInvalids().contains(value.getCharm().getType())) {
                this.apply((ICharmEntity)value);
                entity.getAppliedTo().add(value.getCharm().getType());
                entity.setApplied(true);
            }
        });
    }

    protected void apply(ICharmEntity entity) {
        entity.setMana(entity.getMana() * 1.25);
        entity.setMaxMana(entity.getMaxMana() * 1.25);
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.getCharmEntities().forEach((key, value) -> {
            if (entity.isAppliedTo(value.getCharm().getType())) {
                value.setMana(value.getMana() / 1.25);
                value.setMaxMana(value.getMaxMana() / 1.25);
                entity.getAppliedTo().remove(value.getCharm().getType());
            }
        });
        entity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new ManaRune(this);
        }
    }
}

