/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.cost.EquipmentCostEvaluator;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EquipmentManaRune
extends Rune {
    protected EquipmentManaRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity runestoneEntity) {
        if (!this.isValid(itemStack)) {
            return;
        }
        ICharmableCapability charmableCap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        charmableCap.getCharmEntities().forEach((type, charmEntity) -> {
            charmEntity.setCostEvaluator(new EquipmentCostEvaluator(charmEntity.getCostEvaluator()));
            Treasure.LOGGER.debug("setting entity -> {} to use cost eval -> {} with child eval -> {}", (Object)charmEntity.getCharm().getName().toString(), (Object)charmEntity.getCostEvaluator().getClass().getSimpleName(), (Object)((EquipmentCostEvaluator)charmEntity.getCostEvaluator()).getEvaluator().getClass().getSimpleName());
        });
        runestoneEntity.setApplied(true);
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity runestoneEntity) {
        ICharmableCapability charmableCap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        charmableCap.getCharmEntities().forEach((type, charmEntity) -> {
            if (charmEntity.getCostEvaluator() instanceof EquipmentCostEvaluator) {
                charmEntity.setCostEvaluator(((EquipmentCostEvaluator)charmEntity.getCostEvaluator()).getEvaluator());
            }
        });
        runestoneEntity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new EquipmentManaRune(this);
        }
    }
}

