/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DurabilityRune
extends Rune {
    protected DurabilityRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        return itemStack.hasCapability(TreasureCapabilities.DURABILITY, null);
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        Treasure.LOGGER.debug("applying durability...");
        if (!this.isValid(itemStack) || entity.isApplied()) {
            return;
        }
        Treasure.LOGGER.debug("passed validity check...");
        if (itemStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            IDurabilityCapability cap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null);
            Treasure.LOGGER.debug("old durability -> {}", (Object)cap.getDurability());
            cap.setMaxDurability((int)Math.round((double)cap.getMaxDurability() * 1.25));
            cap.setDurability((int)Math.round((double)cap.getDurability() * 1.25));
            Treasure.LOGGER.debug("new durability -> {}", (Object)cap.getDurability());
            entity.setApplied(true);
        }
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        IDurabilityCapability cap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null);
        cap.setDurability((int)Math.round((double)cap.getDurability() / 1.25));
        cap.setMaxDurability((int)Math.round((double)cap.getMaxDurability() / 1.25));
        entity.setApplied(false);
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new DurabilityRune(this);
        }
    }
}

