/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.rune;

import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.rune.IRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.Rune;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class AnvilRune
extends Rune {
    protected AnvilRune(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isValid(ItemStack itemStack) {
        IDurabilityCapability cap;
        return itemStack.hasCapability(TreasureCapabilities.DURABILITY, null) && !(cap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null)).isInfinite();
    }

    @Override
    public void apply(ItemStack itemStack, IRuneEntity entity) {
        if (!this.isValid(itemStack) || entity.isApplied()) {
            return;
        }
        if (itemStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            IDurabilityCapability cap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null);
            cap.setInfinite(true);
            entity.setApplied(true);
        }
    }

    @Override
    public void undo(ItemStack itemStack, IRuneEntity entity) {
        if (itemStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            IDurabilityCapability cap = (IDurabilityCapability)itemStack.getCapability(TreasureCapabilities.DURABILITY, null);
            cap.setInfinite(false);
            entity.setApplied(false);
        }
    }

    @Override
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag, IRuneEntity entity) {
        TextFormatting color = TextFormatting.LIGHT_PURPLE;
        tooltip.add(color + "" + I18n.func_74837_a((String)"tooltip.indent2", (Object[])new Object[]{I18n.func_74838_a((String)("runestone." + this.getName().toString() + ".name"))}));
    }

    public static class Builder
    extends Rune.Builder {
        public Builder(ResourceLocation name) {
            super(name);
        }

        @Override
        public IRune build() {
            return new AnvilRune(this);
        }
    }
}

