/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.registry.ITreasureResourceRegistry;
import com.someguyssoftware.treasure2.registry.Manifest;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import com.someguyssoftware.treasure2.world.gen.structure.TreasureTemplateManager;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TreasureTemplateRegistry {
    private static final String TEMPLATES_FOLDER = "structures";
    private static final TreasureTemplateManager TEMPLATE_MANAGER = new TreasureTemplateManager(Treasure.instance, "/structures", (DataFixer)FMLCommonHandler.instance().getDataFixer());
    private static final Set<String> MODS = Sets.newHashSet();
    private static final Map<String, Boolean> MODS_LOADED = Maps.newHashMap();
    private static WorldServer world;

    private TreasureTemplateRegistry() {
    }

    public static void create(WorldServer world) {
        TreasureTemplateRegistry.world = world;
        TEMPLATE_MANAGER.setWorldSaveFolder(Paths.get(world.func_72860_G().func_75765_b().getPath(), new String[0]).toFile());
    }

    public static void register(String modID) {
        MODS.add(modID);
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (WorldInfo.isServerSide(event.getWorld()) && event.getWorld().field_73011_w.getDimension() == 0) {
            Treasure.LOGGER.debug("template registry world load");
            TreasureTemplateRegistry.create((WorldServer)event.getWorld());
            MODS.forEach(mod -> {
                Treasure.LOGGER.debug("registering mod -> {}", mod);
                TreasureTemplateRegistry.load(mod);
            });
        }
    }

    public static void load(String modID) {
        if (MODS_LOADED.containsKey(modID)) {
            return;
        }
        Manifest manifest = null;
        boolean worldSaveMetaLoaded = false;
        File manifestFile = Paths.get(world.func_72860_G().func_75765_b().getPath(), "data", TEMPLATES_FOLDER, modID, "manifest.json").toFile();
        if (manifestFile.exists() && manifestFile.isFile()) {
            try {
                String json = Files.toString((File)manifestFile, (Charset)StandardCharsets.UTF_8);
                manifest = (Manifest)new GsonBuilder().create().fromJson(json, Manifest.class);
                worldSaveMetaLoaded = true;
                Treasure.LOGGER.debug("loaded template manifest from file system");
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Couldn't load template manifest from {}", (Object)manifestFile, (Object)e);
            }
        }
        if (!worldSaveMetaLoaded) {
            try {
                Path manifestPath = Paths.get(TEMPLATES_FOLDER, modID, "manifest.json");
                manifest = ITreasureResourceRegistry.readResourcesFromFromStream(Objects.requireNonNull(Treasure.instance.getClass().getClassLoader().getResourceAsStream("structures/" + modID + "/manifest.json")), Manifest.class);
                Treasure.LOGGER.debug("loaded template manifest from jar");
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Unable to load template resources");
            }
        }
        if (manifest != null) {
            TEMPLATE_MANAGER.register(modID, manifest.getResources());
        }
    }

    public void clear() {
        TEMPLATE_MANAGER.clear();
    }

    public static TemplateHolder get(World world, Random random, StructureArchetype archetype, StructureType type, Biome biome) {
        return TEMPLATE_MANAGER.getTemplate(world, random, archetype, type, biome);
    }

    public static TreasureTemplateManager getManager() {
        return TEMPLATE_MANAGER;
    }
}

