/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.TreasureMetaManager;
import com.someguyssoftware.treasure2.registry.ITreasureResourceRegistry;
import com.someguyssoftware.treasure2.registry.Manifest;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;

public class TreasureMetaRegistry {
    private static final String META_FOLDER = "meta";
    private static final TreasureMetaManager META_MANAGER = new TreasureMetaManager();
    private static final Set<String> REGISTERED_MODS = Sets.newHashSet();
    private static final Map<String, Boolean> LOADED_MODS = Maps.newHashMap();
    private static WorldServer world;

    private TreasureMetaRegistry() {
    }

    public static void create(WorldServer world) {
        TreasureMetaRegistry.world = world;
        META_MANAGER.setWorldSaveFolder(Paths.get(world.func_72860_G().func_75765_b().getPath(), new String[0]).toFile());
    }

    public static void register(String modID) {
        REGISTERED_MODS.add(modID);
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (WorldInfo.isServerSide(event.getWorld()) && event.getWorld().field_73011_w.getDimension() == 0) {
            Treasure.LOGGER.debug("meta registry world load");
            TreasureMetaRegistry.create((WorldServer)event.getWorld());
            REGISTERED_MODS.forEach(mod -> {
                Treasure.LOGGER.debug("registering mod -> {}", mod);
                TreasureMetaRegistry.load(mod);
            });
        }
    }

    public static void load(String modID) {
        if (LOADED_MODS.containsKey(modID)) {
            return;
        }
        Manifest manifest = null;
        boolean worldSaveMetaLoaded = false;
        File manifestFile = Paths.get(world.func_72860_G().func_75765_b().getPath(), "data", META_FOLDER, modID, "manifest.json").toFile();
        if (manifestFile.exists() && manifestFile.isFile()) {
            try {
                String json = Files.toString((File)manifestFile, (Charset)StandardCharsets.UTF_8);
                manifest = (Manifest)new GsonBuilder().create().fromJson(json, Manifest.class);
                worldSaveMetaLoaded = true;
                Treasure.LOGGER.debug("loaded meta manifest from file system");
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Couldn't load meta manifest from {}", (Object)manifestFile, (Object)e);
            }
        }
        if (!worldSaveMetaLoaded) {
            try {
                manifest = ITreasureResourceRegistry.readResourcesFromFromStream(Objects.requireNonNull(Treasure.instance.getClass().getClassLoader().getResourceAsStream("meta/" + modID + "/manifest.json")), Manifest.class);
                Treasure.LOGGER.debug("loaded meta manifest from jar");
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Unable to template resources");
            }
        }
        if (manifest != null) {
            LOADED_MODS.put(modID, true);
            META_MANAGER.register(modID, manifest.getResources());
        }
    }

    public static void clear() {
        META_MANAGER.clear();
    }

    public static StructureMeta get(String key) {
        return META_MANAGER.get(key);
    }

    public static TreasureMetaManager getMetaManager() {
        return META_MANAGER;
    }
}

