/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.registry.ITreasureResourceRegistry;
import com.someguyssoftware.treasure2.registry.Manifest;
import com.someguyssoftware.treasure2.world.gen.structure.TreasureDecayManager;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;

public class TreasureDecayRegistry {
    private static final String DECAY_FOLDER = "decay";
    private static final TreasureDecayManager DECAY_MANAGER = new TreasureDecayManager();
    private static final Set<String> MODS = Sets.newHashSet();
    private static final Map<String, Boolean> MODS_LOADED = Maps.newHashMap();
    private static WorldServer world;

    private TreasureDecayRegistry() {
    }

    public static void create(WorldServer world) {
        TreasureDecayRegistry.world = world;
        DECAY_MANAGER.setWorldSaveFolder(Paths.get(world.func_72860_G().func_75765_b().getPath(), new String[0]).toFile());
    }

    public static void register(String modID) {
        MODS.add(modID);
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (WorldInfo.isServerSide(event.getWorld()) && event.getWorld().field_73011_w.getDimension() == 0) {
            Treasure.LOGGER.debug("decay registry world load");
            TreasureDecayRegistry.create((WorldServer)event.getWorld());
            MODS.forEach(mod -> {
                Treasure.LOGGER.debug("registering mod -> {}", mod);
                TreasureDecayRegistry.load(mod);
            });
        }
    }

    public static void load(String modID) {
        if (MODS_LOADED.containsKey(modID)) {
            return;
        }
        Manifest manifest = null;
        boolean worldSaveMetaLoaded = false;
        File manifestFile = Paths.get(world.func_72860_G().func_75765_b().getPath(), "data", TreasureDecayRegistry.getResourceFolder(), modID, "manifest.json").toFile();
        if (manifestFile.exists() && manifestFile.isFile()) {
            try {
                String json = Files.toString((File)manifestFile, (Charset)StandardCharsets.UTF_8);
                manifest = (Manifest)new GsonBuilder().create().fromJson(json, Manifest.class);
                worldSaveMetaLoaded = true;
                Treasure.LOGGER.debug("loaded {} manifest from file system", (Object)TreasureDecayRegistry.getResourceFolder());
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Couldn't load {} manifest from {}", (Object)TreasureDecayRegistry.getResourceFolder(), (Object)manifestFile, (Object)e);
            }
        }
        if (!worldSaveMetaLoaded) {
            try {
                manifest = ITreasureResourceRegistry.readResourcesFromFromStream(Objects.requireNonNull(Treasure.instance.getClass().getClassLoader().getResourceAsStream("decay/" + modID + "/manifest.json")), Manifest.class);
                Treasure.LOGGER.debug("loaded decay manifest from jar");
            }
            catch (Exception e) {
                Treasure.LOGGER.warn("Unable to decay resources");
            }
        }
        if (manifest != null) {
            DECAY_MANAGER.register(modID, manifest.getResources());
        }
    }

    public void clear() {
        DECAY_MANAGER.clear();
    }

    protected static String getResourceFolder() {
        return DECAY_FOLDER;
    }

    public static TreasureDecayManager getManager() {
        return DECAY_MANAGER;
    }
}

