/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ChestRegistry {
    private static final int MAX_SIZE = TreasureConfig.CHESTS.chestRegistrySize;
    private static ChestRegistry instance = new ChestRegistry();
    private ListMultimap<String, ChestInfo> registry = LinkedListMultimap.create();

    private ChestRegistry() {
    }

    public static ChestRegistry getInstance() {
        return instance;
    }

    public boolean isRegistered(String key) {
        return this.registry.containsKey((Object)key);
    }

    public synchronized void register(String key, ChestInfo info) {
        Treasure.LOGGER.debug("Registering chest using key: " + key);
        if (this.registry.size() >= MAX_SIZE) {
            String headKey = (String)this.registry.keySet().iterator().next();
            this.unregister(headKey);
        }
        this.registry.put((Object)key, (Object)info);
    }

    public synchronized void unregister(String key) {
        if (this.registry.containsKey((Object)key)) {
            this.registry.removeAll((Object)key);
        }
    }

    public List<ChestInfo> get(String key) {
        List info = null;
        if (this.registry.containsKey((Object)key)) {
            info = this.registry.get((Object)key);
        }
        return info;
    }

    public List<ChestInfo> getValues() {
        HashSet set = Sets.newHashSet((Iterable)this.registry.values());
        return new ArrayList<ChestInfo>(set);
    }

    public void clear() {
        this.registry.clear();
    }
}

