/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.particle;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.particle.IMistParticle;
import com.someguyssoftware.treasure2.tileentity.MistEmitterTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractMistParticle
extends Particle
implements IMistParticle {
    public static final int DEFAULT_PARTICLE_MAX_AGE = 320;
    public static final int DEFAULT_PARTICLE_MAX_SCALE = 12;
    public static final float DEFAULT_PARTICLE_ALPHA = 0.1f;
    public static final float DEFAULT_PARTICLE_GRAVITY = 0.001f;
    private static final int TRANSITION_IN_STOP_AGE = 105;
    private static final int TRANSITION_OUT_START_AGE = 240;
    private static final float TRANSITION_IN_START_SCALE = 2.0f;
    private static final float TRANSITION_OUT_FINAL_SCALE = 2.0f;
    private static final int DEFAULT_BRIGHTNESS = 0xE3E3E3;
    private ICoords parentEmitterCoords;
    private float transitionInScaleIncrement;
    private float transitionOutScaleIncrement;

    protected AbstractMistParticle(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_187129_i = (Math.random() * 2.0 - 1.0) * 0.00502;
        this.field_187131_k = (Math.random() * 2.0 - 1.0) * 0.00502;
        this.field_187130_j = 0.0;
    }

    @Override
    public void init() {
        this.transitionInScaleIncrement = (this.provideMaxScale() - 2.0f) / 105.0f;
        this.transitionOutScaleIncrement = (this.provideMaxScale() - 2.0f) / (float)(this.provideMaxAge() - 240);
        this.field_70545_g = this.provideGravity();
        this.field_70547_e = this.provideMaxAge();
        this.field_82339_as = this.provideAlpha();
        this.field_70544_f = 2.0f;
    }

    public void func_189213_a() {
        this.doPlayerCollisions((World)Minecraft.func_71410_x().field_71441_e);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (!this.field_187132_l) {
            this.field_187130_j -= (double)this.provideGravity();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.doTransitions();
        if (this.field_187124_d != this.field_187127_g || this.field_187130_j > 0.0) {
            // empty if block
        }
        if (this.field_70546_d++ >= this.provideMaxAge()) {
            this.func_187112_i();
        }
    }

    public void doTransitions() {
        this.transitionIn(2.0f, 105, this.getTransitionInScaleIncrement());
        this.transitionOut(2.0f, 240, this.getTransitionOutScaleIncrement());
    }

    @Override
    public void transitionIn(float initialScale, int stopAge, float scaleIncrement) {
        if (this.field_70546_d < stopAge && this.getScale() < this.provideMaxScale()) {
            this.field_70544_f += scaleIncrement;
        }
    }

    @Override
    public void transitionOut(float finalScale, int startAge, float scaleIncrement) {
        if (this.field_70546_d >= startAge && this.getScale() > finalScale) {
            this.field_70544_f -= scaleIncrement;
        }
    }

    public void doPlayerCollisions(World world) {
        if (this.getParentEmitterCoords() == null) {
            Treasure.LOGGER.debug("emitter coords is null");
            return;
        }
        TileEntity emitterTileEntity = world.func_175625_s(this.getParentEmitterCoords().toPos());
        if (emitterTileEntity == null) {
            return;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_187126_f - 0.125, this.field_187127_g, this.field_187128_h - 0.125, this.field_187126_f + 0.125, this.field_187127_g + 0.25, this.field_187128_h + 0.125);
        for (EntityPlayer player : ((MistEmitterTileEntity)emitterTileEntity).getPlayersWithinProximity()) {
            if (!player.func_174813_aQ().func_72326_a(aabb)) continue;
            this.inflictEffectOnPlayer(player);
        }
    }

    public abstract void inflictEffectOnPlayer(EntityPlayer var1);

    public int func_70537_b() {
        return 1;
    }

    public int func_189214_a(float partialTick) {
        return 0xE3E3E3;
    }

    public boolean func_187111_c() {
        return true;
    }

    @Override
    public ICoords getParentEmitterCoords() {
        return this.parentEmitterCoords;
    }

    @Override
    public void setParentEmitterCoords(ICoords parentEmitterCoords) {
        this.parentEmitterCoords = parentEmitterCoords;
    }

    @Override
    public float getGravity() {
        return this.field_70545_g;
    }

    @Override
    public float getScale() {
        return this.field_70544_f;
    }

    @Override
    public float getAlpha() {
        return this.field_82339_as;
    }

    @Override
    public float provideGravity() {
        return 0.001f;
    }

    @Override
    public float provideAlpha() {
        return 0.1f;
    }

    @Override
    public int provideMaxAge() {
        return 320;
    }

    @Override
    public float provideMaxScale() {
        return 12.0f;
    }

    @Override
    public float getTransitionInScaleIncrement() {
        return this.transitionInScaleIncrement;
    }

    @Override
    public void setTransitionInScaleIncrement(float transitionInScaleIncrement) {
        this.transitionInScaleIncrement = transitionInScaleIncrement;
    }

    @Override
    public float getTransitionOutScaleIncrement() {
        return this.transitionOutScaleIncrement;
    }

    @Override
    public void setTransitionOutScaleIncrement(float transitionOutScaleIncrement) {
        this.transitionOutScaleIncrement = transitionOutScaleIncrement;
    }
}

