/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.network;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.charm.CharmContext;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.ICooldownCharmEntity;
import com.someguyssoftware.treasure2.charm.TreasureCharmRegistry;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CharmMessageToClient
implements IMessage {
    private boolean valid;
    private String playerName;
    private String charmName;
    private ICharmEntity entity;
    private EnumHand hand;
    private Integer slot;
    private String slotProviderId;
    private InventoryType inventoryType;
    private int index;
    private int itemDamage;

    public CharmMessageToClient(String playerName, CharmContext context) {
        this.valid = true;
        this.playerName = playerName;
        this.charmName = context.getEntity().getCharm().getName().toString();
        this.entity = context.getEntity();
        this.hand = context.getHand();
        this.slotProviderId = context.getSlotProviderId();
        this.slot = context.getSlot();
        this.inventoryType = context.getType();
        this.index = context.getIndex();
        this.itemDamage = context.getItemStack().func_77952_i();
    }

    public CharmMessageToClient() {
        this.valid = false;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            String handStr;
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.charmName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            Optional<ICharm> optionalCharm = TreasureCharmRegistry.get(ResourceLocationUtil.create(this.charmName));
            if (!optionalCharm.isPresent()) {
                throw new RuntimeException(String.format("Unable to find charm %s in registry.", this.charmName));
            }
            this.entity = optionalCharm.get().createEntity();
            this.entity.setCharm(optionalCharm.get());
            this.entity.setMana(buf.readDouble());
            if (this.entity instanceof ICooldownCharmEntity) {
                ((ICooldownCharmEntity)((Object)this.entity)).setCooldownEnd(buf.readDouble());
            }
            if (!(handStr = ByteBufUtils.readUTF8String((ByteBuf)buf)).isEmpty()) {
                this.hand = EnumHand.valueOf((String)handStr);
            }
            this.slot = buf.readInt();
            this.slotProviderId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            String inventoryType = ByteBufUtils.readUTF8String((ByteBuf)buf);
            if (!inventoryType.isEmpty()) {
                this.setInventoryType(InventoryType.valueOf(inventoryType.toUpperCase()));
            }
            this.setIndex(buf.readInt());
            this.setItemDamage(buf.readInt());
        }
        catch (RuntimeException e) {
            Treasure.LOGGER.error("Exception while reading CharmMessageToClient: ", (Throwable)e);
            return;
        }
        this.valid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.valid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.charmName);
        buf.writeDouble(this.entity.getMana());
        if (this.entity instanceof ICooldownCharmEntity) {
            buf.writeDouble(((ICooldownCharmEntity)((Object)this.entity)).getCooldownEnd());
        }
        String handStr = "";
        if (this.hand != null) {
            handStr = this.hand.name();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)handStr);
        buf.writeInt(this.slot.intValue());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Objects.toString(this.slotProviderId, ""));
        String typeAsString = "";
        if (this.inventoryType != null) {
            typeAsString = this.inventoryType.name().toLowerCase();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)typeAsString);
        buf.writeInt(this.index);
        buf.writeInt(this.itemDamage);
    }

    public boolean isMessageValid() {
        return this.charmName != null && this.playerName != null && this.entity != null;
    }

    public boolean isMessageIsValid() {
        return this.valid;
    }

    public void setValid(boolean messageIsValid) {
        this.valid = messageIsValid;
    }

    public ICharmEntity getEntity() {
        return this.entity;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public String getCharmName() {
        return this.charmName;
    }

    public String getSlotProviderId() {
        return this.slotProviderId;
    }

    public void setSlotProviderId(String slotProviderId) {
        this.slotProviderId = slotProviderId;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public void setCharmName(String charmName) {
        this.charmName = charmName;
    }

    public void setEntity(ICharmEntity entity) {
        this.entity = entity;
    }

    public void setHand(EnumHand hand) {
        this.hand = hand;
    }

    public void setSlot(Integer slot) {
        this.slot = slot;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        return "CharmMessageToClient [valid=" + this.valid + ", playerName=" + this.playerName + ", charmName=" + this.charmName + ", entity=" + this.entity + ", hand=" + this.hand + ", slot=" + this.slot + ", slotProviderId=" + this.slotProviderId + ", inventoryType=" + (Object)((Object)this.inventoryType) + ", index=" + this.index + ", itemDamage=" + this.itemDamage + "]";
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public void setItemDamage(int itemDamage) {
        this.itemDamage = itemDamage;
    }
}

