/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.network;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.integration.baubles.BaublesIntegration;
import com.someguyssoftware.treasure2.network.CharmMessageToClient;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CharmMessageHandlerOnClient
implements IMessageHandler<CharmMessageToClient, IMessage> {
    public IMessage onMessage(final CharmMessageToClient message, MessageContext ctx) {
        if (ctx.side != Side.CLIENT) {
            Treasure.LOGGER.error("CharmedItemMessageToClient received on wrong side -> {}", (Object)ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            Treasure.LOGGER.warn("CharmedItemMessageToClient was invalid -> {}", (Object)message.toString());
            return null;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        final WorldClient worldClient = minecraft.field_71441_e;
        minecraft.func_152344_a(new Runnable(){

            @Override
            public void run() {
                CharmMessageHandlerOnClient.this.processMessage(worldClient, message);
            }
        });
        return null;
    }

    void processMessage(WorldClient worldClient, CharmMessageToClient message) {
        Treasure.LOGGER.debug("received charm message -> {}", (Object)message);
        try {
            EntityPlayer player = worldClient.func_152378_a(UUID.fromString(message.getPlayerName()));
            if (player != null) {
                if (message.getHand() != null) {
                    ItemStack heldItemStack = player.func_184586_b(message.getHand());
                    if (heldItemStack != null && heldItemStack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
                        this.updateCharms(heldItemStack, message, (ICharmableCapability)heldItemStack.getCapability(TreasureCapabilities.CHARMABLE, null));
                    }
                } else if ("baubles".equals(message.getSlotProviderId())) {
                    ItemStack stack = BaublesIntegration.getStackInSlot(player, message.getSlot());
                    if (stack != null && stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
                        this.updateCharms(stack, message, (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null));
                    }
                } else {
                    ItemStack stack = player.field_71071_by.func_70301_a(message.getSlot().intValue());
                    if (stack != null && stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
                        this.updateCharms(stack, message, (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null));
                    }
                }
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unexpected error ->", (Throwable)e);
        }
    }

    private void updateCharms(ItemStack itemStack, CharmMessageToClient message, ICharmableCapability capability) {
        ICharmEntity entity;
        ResourceLocation charmName = new ResourceLocation(message.getCharmName());
        List entityList = (List)capability.getCharmEntities().get((Object)message.getInventoryType());
        if (entityList != null && !entityList.isEmpty() && entityList.size() > message.getIndex() && (entity = (ICharmEntity)entityList.get(message.getIndex())) != null && entity.getCharm().getName().equals((Object)charmName)) {
            entity.update(message.getEntity());
            if (message.getInventoryType() == InventoryType.INNATE && entity.getMana() <= 0.0) {
                capability.remove(message.getInventoryType(), message.getIndex());
            }
            if (itemStack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
                itemStack.func_77964_b(message.getItemDamage());
            }
        }
    }
}

