/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.meta;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.someguyssoftware.gottschcore.enums.IRarity;
import com.someguyssoftware.gottschcore.meta.IMeta;
import com.someguyssoftware.gottschcore.meta.IMetaArchetype;
import com.someguyssoftware.gottschcore.meta.IMetaTheme;
import com.someguyssoftware.gottschcore.meta.IMetaType;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureTheme;
import com.someguyssoftware.treasure2.meta.StructureType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public class TreasureMetaManager {
    protected static final Gson GSON_INSTANCE;
    private File worldSaveFolder;
    private final Map<String, IMeta> metaMap = Maps.newHashMap();

    public void clear() {
        this.getMetaMap().clear();
    }

    public void register(String modID, List<String> resourcePaths) {
        Treasure.LOGGER.debug("registering meta resources");
        this.createMetaFolder(this.getWorldSaveFolder(), modID);
        Treasure.LOGGER.debug("created meta folder");
        List<ResourceLocation> resourceLocations = this.getMetaResourceLocations(modID, resourcePaths);
        Treasure.LOGGER.debug("acquired resource locations -> {}", resourceLocations);
        resourceLocations.forEach(loc -> {
            Treasure.LOGGER.debug("register metas -> loading meta resource loc -> {}", (Object)loc.toString());
            this.tableMeta((ResourceLocation)loc, this.loadMeta((ResourceLocation)loc));
        });
    }

    private void createMetaFolder(File worldSaveFolder, String modID) {
        Path folder = Paths.get(worldSaveFolder.getPath(), "data/meta", modID, "structures").toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            Treasure.LOGGER.debug("meta folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                Treasure.LOGGER.warn("Unable to create meta folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    private void tableMeta(ResourceLocation resourceLocation, Optional<StructureMeta> meta) {
        if (meta.isPresent()) {
            Treasure.LOGGER.debug("tabling meta: key -> {}, meta -> {}", (Object)resourceLocation.toString(), meta);
            this.getMetaMap().put(resourceLocation.toString(), meta.get());
        } else {
            Treasure.LOGGER.debug("unable to table meta from -> {}", (Object)resourceLocation);
        }
    }

    public List<ResourceLocation> getMetaResourceLocations(String modID, List<String> resources) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        resources.forEach(resource -> resourceLocations.add(new ResourceLocation(modID, resource)));
        return resourceLocations;
    }

    public Optional<StructureMeta> loadMeta(ResourceLocation resource) {
        Optional<StructureMeta> meta = this.loadMetaFromWorldSave(this.getWorldSaveFolder(), resource);
        if (!meta.isPresent()) {
            return this.loadMetaFromJar(resource);
        }
        return meta;
    }

    private Optional<StructureMeta> loadMetaFromJar(ResourceLocation resource) {
        Optional<StructureMeta> resourceMeta = Optional.empty();
        String relativePath = "meta/" + resource.func_110624_b() + "/" + resource.func_110623_a();
        Treasure.LOGGER.debug("attempting to load meta {} from jar -> {}", (Object)resource, (Object)relativePath);
        try (InputStream resourceStream = Treasure.instance.getClass().getClassLoader().getResourceAsStream(relativePath);
             InputStreamReader reader = new InputStreamReader(resourceStream, StandardCharsets.UTF_8);){
            resourceMeta = Optional.of(this.loadMeta(reader));
        }
        catch (Exception e) {
            Treasure.LOGGER.error(String.format("couldn't load resource meta %s ", relativePath), (Throwable)e);
        }
        return resourceMeta;
    }

    private Optional<StructureMeta> loadMetaFromWorldSave(File folder, ResourceLocation resource) {
        if (folder == null) {
            return Optional.empty();
        }
        File metaFile = Paths.get(folder.getPath(), "data", "meta", resource.func_110624_b(), resource.func_110623_a()).toFile();
        Treasure.LOGGER.debug("attempting to load meta {} from {}", (Object)resource, (Object)metaFile);
        if (metaFile.exists()) {
            if (metaFile.isFile()) {
                String json;
                try {
                    json = com.google.common.io.Files.toString((File)metaFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    Treasure.LOGGER.warn("couldn't load meta {} from {}", (Object)resource, (Object)metaFile, (Object)e);
                    return Optional.empty();
                }
                try {
                    return Optional.of(this.loadMeta(json));
                }
                catch (JsonParseException | IllegalArgumentException e) {
                    Treasure.LOGGER.error("couldn't load meta {} from {}", (Object)resource, (Object)metaFile, (Object)e);
                    return Optional.empty();
                }
            }
            Treasure.LOGGER.warn("expected to find meta {} at {} but it was a folder.", (Object)resource, (Object)metaFile);
            return Optional.empty();
        }
        Treasure.LOGGER.warn("expected to find meta {} at {} but it doesn't exist.", (Object)resource, (Object)metaFile);
        return Optional.empty();
    }

    public StructureMeta loadMeta(Reader reader) {
        return (StructureMeta)GSON_INSTANCE.fromJson(reader, StructureMeta.class);
    }

    public StructureMeta loadMeta(String json) throws IllegalArgumentException, JsonParseException {
        return (StructureMeta)GSON_INSTANCE.fromJson(json, StructureMeta.class);
    }

    public StructureMeta get(String key) {
        return (StructureMeta)this.getMetaMap().get(key);
    }

    public File getWorldSaveFolder() {
        return this.worldSaveFolder;
    }

    public void setWorldSaveFolder(File worldSaveFolder) {
        this.worldSaveFolder = worldSaveFolder;
    }

    public Map<String, IMeta> getMetaMap() {
        return this.metaMap;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type metaArchetype = new TypeToken<List<IMetaArchetype>>(){}.getType();
        Type metaTheme = new TypeToken<List<IMetaTheme>>(){}.getType();
        Type rarity = new TypeToken<List<IRarity>>(){}.getType();
        GSON_INSTANCE = gsonBuilder.registerTypeAdapter(metaArchetype, (Object)new MetaArchetypeDeserializer()).registerTypeAdapter(IMetaType.class, (Object)new MetaTypeDeserializer()).registerTypeAdapter(metaTheme, (Object)new MetaThemeDeserializer()).registerTypeAdapter(rarity, (Object)new RarityDeserializer()).registerTypeAdapter(ICoords.class, (Object)new CoordsDeserializer()).create();
    }

    public static class CoordsDeserializer
    implements JsonDeserializer<Coords> {
        public Coords deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (Coords)context.deserialize(json, Coords.class);
        }
    }

    public static class RarityDeserializer
    implements JsonDeserializer<List<IRarity>> {
        public List<IRarity> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<IRarity> list = new ArrayList<IRarity>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement e : array) {
                list.add(Rarity.valueOf(e.getAsString().toUpperCase()));
            }
            return list;
        }
    }

    public static class MetaThemeDeserializer
    implements JsonDeserializer<List<IMetaTheme>> {
        public List<IMetaTheme> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<IMetaTheme> list = new ArrayList<IMetaTheme>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement e : array) {
                list.add(StructureTheme.valueOf(e.getAsString().toUpperCase()));
            }
            return list;
        }
    }

    public static class MetaTypeDeserializer
    implements JsonDeserializer<StructureType> {
        public StructureType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return StructureType.valueOf(json.getAsString().toUpperCase());
        }
    }

    public static class MetaArchetypeDeserializer
    implements JsonDeserializer<List<IMetaArchetype>> {
        public List<IMetaArchetype> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<IMetaArchetype> list = new ArrayList<IMetaArchetype>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement e : array) {
                list.add(StructureArchetype.valueOf(e.getAsString().toUpperCase()));
            }
            return list;
        }
    }
}

