/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.material;

import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.material.CharmableMaterial;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;

public class TreasureCharmableMaterials {
    public static final CharmableMaterial IRON = new CharmableMaterial(1, ResourceLocationUtil.create("iron"), 2, 1, 0.25, 75, 5);
    public static final CharmableMaterial COPPER = new CharmableMaterial(2, ResourceLocationUtil.create("copper"), 4, 1, 0.5, 10, 4);
    public static final CharmableMaterial SILVER = new CharmableMaterial(3, ResourceLocationUtil.create("silver"), 6, 3, 0.75, 20, 3);
    public static final CharmableMaterial GOLD = new CharmableMaterial(4, ResourceLocationUtil.create("gold"), 8, 5, 1.0, 25, 2);
    public static final CharmableMaterial BLOOD = new CharmableMaterial(5, ResourceLocationUtil.create("blood"), 10, 6, 1.0, 15, 1);
    public static final CharmableMaterial BONE = new CharmableMaterial(6, ResourceLocationUtil.create("bone"), 12, 8, 1.15, 50, 0);
    public static final CharmableMaterial BLACK = new CharmableMaterial(7, ResourceLocationUtil.create("black"), 12, 10, 1.15, 35, 2);
    public static final CharmableMaterial ATIUM = new CharmableMaterial(8, ResourceLocationUtil.create("atium"), 14, 10, 1.25, 100, 5);
    public static final CharmableMaterial CHARM_BOOK = new CharmableMaterial(100, ResourceLocationUtil.create("charm_book"), 100);
    public static final CharmableMaterial LEGENDARY = new CharmableMaterial(9, ResourceLocationUtil.create("legendary"), 24);
    public static final CharmableMaterial MYTHICAL = new CharmableMaterial(10, ResourceLocationUtil.create("mythical"), 28);
    public static CharmableMaterial DIAMOND;
    public static CharmableMaterial EMERALD;
    public static CharmableMaterial AMETHYST;
    public static CharmableMaterial ONYX;
    public static CharmableMaterial RUBY;
    public static CharmableMaterial SAPPHIRE;
    public static CharmableMaterial WHITE_PEARL;
    public static CharmableMaterial BLACK_PEARL;
    private static final Map<ResourceLocation, CharmableMaterial> METAL_REGISTRY;
    private static final Map<ResourceLocation, CharmableMaterial> GEM_REGISTRY;
    public static Comparator<CharmableMaterial> levelComparator;

    public static void setup() {
        AMETHYST = new CharmableMaterial(1, TreasureItems.AMETHYST.getRegistryName(), 2, 1);
        DIAMOND = new CharmableMaterial(2, Items.field_151045_i.getRegistryName(), 4, 3);
        ONYX = new CharmableMaterial(3, TreasureItems.ONYX.getRegistryName(), 6, 3);
        EMERALD = new CharmableMaterial(4, Items.field_151166_bC.getRegistryName(), 8, 3);
        RUBY = new CharmableMaterial(5, TreasureItems.RUBY.getRegistryName(), 10, 4);
        SAPPHIRE = new CharmableMaterial(6, TreasureItems.SAPPHIRE.getRegistryName(), 12, 6);
        WHITE_PEARL = new CharmableMaterial(7, TreasureItems.WHITE_PEARL.getRegistryName(), 10, 8);
        BLACK_PEARL = new CharmableMaterial(8, TreasureItems.BLACK_PEARL.getRegistryName(), 12, 10);
        GEM_REGISTRY.put(DIAMOND.getName(), DIAMOND);
        GEM_REGISTRY.put(EMERALD.getName(), EMERALD);
        GEM_REGISTRY.put(AMETHYST.getName(), AMETHYST);
        GEM_REGISTRY.put(ONYX.getName(), ONYX);
        GEM_REGISTRY.put(RUBY.getName(), RUBY);
        GEM_REGISTRY.put(SAPPHIRE.getName(), SAPPHIRE);
        GEM_REGISTRY.put(WHITE_PEARL.getName(), WHITE_PEARL);
        GEM_REGISTRY.put(BLACK_PEARL.getName(), BLACK_PEARL);
    }

    public static List<CharmableMaterial> getGemValues() {
        return new ArrayList<CharmableMaterial>(GEM_REGISTRY.values());
    }

    public static Optional<CharmableMaterial> getBaseMaterial(ResourceLocation name) {
        if (name != null && METAL_REGISTRY.containsKey(name)) {
            return Optional.of(METAL_REGISTRY.get(name));
        }
        return Optional.empty();
    }

    public static Optional<CharmableMaterial> getSourceItem(ResourceLocation sourceItem) {
        if (sourceItem != null && GEM_REGISTRY.containsKey(sourceItem)) {
            return Optional.of(GEM_REGISTRY.get(sourceItem));
        }
        return Optional.empty();
    }

    public static boolean isSourceItemRegistered(ResourceLocation sourceItem) {
        Optional<CharmableMaterial> material = TreasureCharmableMaterials.getSourceItem(sourceItem);
        return material.isPresent();
    }

    static {
        METAL_REGISTRY = new HashMap<ResourceLocation, CharmableMaterial>();
        GEM_REGISTRY = new HashMap<ResourceLocation, CharmableMaterial>();
        METAL_REGISTRY.put(IRON.getName(), IRON);
        METAL_REGISTRY.put(COPPER.getName(), COPPER);
        METAL_REGISTRY.put(SILVER.getName(), SILVER);
        METAL_REGISTRY.put(GOLD.getName(), GOLD);
        METAL_REGISTRY.put(BLOOD.getName(), BLOOD);
        METAL_REGISTRY.put(BONE.getName(), BONE);
        METAL_REGISTRY.put(BLACK.getName(), BLACK);
        METAL_REGISTRY.put(ATIUM.getName(), ATIUM);
        METAL_REGISTRY.put(LEGENDARY.getName(), LEGENDARY);
        METAL_REGISTRY.put(MYTHICAL.getName(), MYTHICAL);
        levelComparator = new SortByLevel();
    }

    public static class SortByLevel
    implements Comparator<CharmableMaterial> {
        @Override
        public int compare(CharmableMaterial p1, CharmableMaterial p2) {
            return Integer.compare(p1.getMaxLevel(), p2.getMaxLevel());
        }
    }
}

