/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot.function;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.TreasureAdornmentRegistry;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.TreasureCharms;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.Adornment;
import com.someguyssoftware.treasure2.material.CharmableMaterial;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class RandomAdornment
extends LootFunction {
    private static final ResourceLocation LOCATION = new ResourceLocation("treasure2:random_adornment");
    private static final String LEVELS = "levels";
    private static final String MATERIALS = "materials";
    private static final String RARITY = "rarity";
    private static final String HAS_GEM = "hasGem";
    private RandomValueRange levels;
    private Optional<List<CharmableMaterial>> materials;
    private Rarity rarity;
    private boolean hasGem;

    public RandomAdornment(LootCondition[] conditions) {
        super(conditions);
    }

    public RandomAdornment(LootCondition[] conditions, RandomValueRange levels, Optional<List<CharmableMaterial>> materials, Rarity rarity, boolean hasGem) {
        super(conditions);
        this.levels = levels;
        this.materials = materials;
        this.rarity = rarity;
        this.hasGem = hasGem;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        ItemStack adornment;
        int level;
        Random random = new Random();
        Treasure.LOGGER.debug("incoming adornment -> {}", (Object)stack.func_82833_r());
        CharmableMaterial material = null;
        material = this.materials == null || !this.materials.isPresent() ? TreasureCharmableMaterials.getBaseMaterial(((ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null)).getBaseMaterial()).get() : this.materials.get().get(random.nextInt(this.materials.get().size()));
        Treasure.LOGGER.debug("selected material -> {}", (Object)material.getName());
        int n = level = this.levels == null ? 1 : this.levels.func_186511_a(rand);
        if (level > material.getMaxLevel()) {
            level = material.getMaxLevel();
        }
        Treasure.LOGGER.debug("rarity -> {}, code -> {}", (Object)this.rarity, (Object)this.rarity.getCode());
        Treasure.LOGGER.debug("material -> {}, maxLevel -> {}", (Object)material.getName(), (Object)material.getMaxLevel());
        Treasure.LOGGER.debug("material rarity -> {}", (Object)TreasureCharms.LEVEL_RARITY.get(material.getMaxLevel()));
        Treasure.LOGGER.debug("updated rarity -> {}, code -> {}", (Object)this.rarity, (Object)this.rarity.getCode());
        Treasure.LOGGER.debug("hasGem -> {}", (Object)this.hasGem);
        int lambdaLevel = level;
        List<Adornment> adornmentsByMaterial = TreasureAdornmentRegistry.getByMaterial(material);
        List adornments = adornmentsByMaterial.stream().filter(a -> {
            boolean hasSource;
            ItemStack itemStack = new ItemStack((Item)a);
            boolean bl = hasSource = ((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem() != Items.field_190931_a.getRegistryName();
            if (!this.hasGem && !hasSource) {
                Treasure.LOGGER.debug("filter: keeping adornment -> {}", (Object)itemStack.func_82833_r());
                return true;
            }
            return this.hasGem && hasSource;
        }).filter(a -> {
            ItemStack itemStack = new ItemStack((Item)a);
            if (this.rarity != null && this.rarity == TreasureCharms.LEVEL_RARITY.get(((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getMaxCharmLevel())) {
                return true;
            }
            return ((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getMaxCharmLevel() == lambdaLevel;
        }).collect(Collectors.toList());
        if (adornments == null || adornments.isEmpty()) {
            Treasure.LOGGER.debug("no adornments match criteria, using incoming adornment -> {}", (Object)stack.func_82833_r());
            adornment = stack;
        } else {
            adornment = new ItemStack((Item)adornments.get(random.nextInt(adornments.size())));
        }
        Treasure.LOGGER.debug("selected adornment -> {}", (Object)adornment.func_82833_r());
        return adornment;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomAdornment> {
        public Serializer() {
            super(LOCATION, RandomAdornment.class);
        }

        public void serialize(JsonObject json, RandomAdornment value, JsonSerializationContext context) {
            json.add(RandomAdornment.LEVELS, context.serialize((Object)value.levels));
            if (value.materials.isPresent()) {
                JsonArray jsonArray = new JsonArray();
                ((List)value.materials.get()).forEach(material -> jsonArray.add((JsonElement)new JsonPrimitive(material.getName().toString())));
                json.add(RandomAdornment.MATERIALS, (JsonElement)jsonArray);
                if (value.rarity != null) {
                    json.add(RandomAdornment.RARITY, (JsonElement)new JsonPrimitive(value.rarity.name()));
                }
                json.add(RandomAdornment.HAS_GEM, (JsonElement)new JsonPrimitive(Boolean.valueOf(value.hasGem)));
            }
        }

        public RandomAdornment deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            RandomValueRange levels = null;
            if (json.has(RandomAdornment.LEVELS)) {
                levels = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)RandomAdornment.LEVELS, (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            Optional<List<CharmableMaterial>> materials = Optional.empty();
            if (json.has(RandomAdornment.MATERIALS)) {
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)RandomAdornment.MATERIALS)) {
                    String materialName = JsonUtils.func_151206_a((JsonElement)element, (String)"material");
                    Optional<CharmableMaterial> material = TreasureCharmableMaterials.getBaseMaterial(ResourceLocationUtil.create(materialName));
                    if (material.isPresent()) {
                        if (!materials.isPresent()) {
                            materials = Optional.of(new ArrayList());
                        }
                        materials.get().add(material.get());
                        continue;
                    }
                    Treasure.LOGGER.warn("Unknown material '{}'", (Object)materialName);
                }
            }
            Rarity rarity = null;
            if (json.has(RandomAdornment.RARITY)) {
                String rarityString = JsonUtils.func_151200_h((JsonObject)json, (String)RandomAdornment.RARITY);
                try {
                    rarity = Rarity.valueOf(rarityString.toUpperCase());
                }
                catch (Exception e) {
                    Treasure.LOGGER.error("Unable to convert rarity {} to Rarity", (Object)rarityString);
                }
            }
            boolean hasGem = false;
            if (json.has(RandomAdornment.HAS_GEM)) {
                hasGem = JsonUtils.func_151212_i((JsonObject)json, (String)RandomAdornment.HAS_GEM);
            }
            return new RandomAdornment(conditionsIn, levels, materials, rarity, hasGem);
        }
    }
}

