/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import com.someguyssoftware.gottschcore.loot.LootTableMaster2;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreasureLootTableMaster2
extends LootTableMaster2 {
    public static Logger LOGGER = LogManager.getLogger((String)Treasure.LOGGER.getName());
    public static final String CUSTOM_LOOT_TABLES_RESOURCE_PATH = "/loot_tables/";
    public static final String CUSTOM_LOOT_TABLE_KEY = "CUSTOM";
    private final Table<String, Rarity, List<ResourceLocation>> CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE = HashBasedTable.create();
    @Deprecated
    private final Table<String, Rarity, List<ResourceLocation>> INJECT_LOOT_TABLES_RESOURCE_LOCATION_TABLE = HashBasedTable.create();
    private final Table<String, Rarity, List<LootTableShell>> CHEST_LOOT_TABLES_TABLE = HashBasedTable.create();
    private final Map<ResourceLocation, LootTableShell> CHEST_LOOT_TABLES_MAP = new HashMap<ResourceLocation, LootTableShell>();
    private final Map<SpecialLootTables, LootTableShell> SPECIAL_LOOT_TABLES_MAP = new HashMap<SpecialLootTables, LootTableShell>();
    private final Table<String, Rarity, List<LootTableShell>> INJECT_LOOT_TABLES_TABLE = HashBasedTable.create();

    public TreasureLootTableMaster2(IMod mod) {
        super(mod);
        for (Rarity r : Rarity.values()) {
            this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.put((Object)CUSTOM_LOOT_TABLE_KEY, (Object)r, new ArrayList());
            this.CHEST_LOOT_TABLES_TABLE.put((Object)CUSTOM_LOOT_TABLE_KEY, (Object)r, new ArrayList());
        }
    }

    @Override
    public void clear() {
        super.clear();
        Treasure.LOGGER.debug("clearing all resource tables");
        this.CHEST_LOOT_TABLES_TABLE.clear();
        this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.clear();
        this.CHEST_LOOT_TABLES_MAP.clear();
        this.SPECIAL_LOOT_TABLES_MAP.clear();
        this.INJECT_LOOT_TABLES_TABLE.clear();
        this.INJECT_LOOT_TABLES_RESOURCE_LOCATION_TABLE.clear();
    }

    public List<ResourceLocation> getLootTablesResourceLocations(String modID, List<String> resources) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        resources.forEach(resource -> resourceLocations.add(new ResourceLocation(modID, resource)));
        return resourceLocations;
    }

    public void registerChests(String modID, List<String> resourcePaths) {
        List<ResourceLocation> resourceLocations = this.getLootTablesResourceLocations(modID, resourcePaths);
        resourceLocations.forEach(loc -> {
            LOGGER.debug("register chests -> loading loot table shell resource loc -> {}", (Object)loc.func_110623_a().toString());
            this.tableChest((ResourceLocation)loc, this.loadLootTable((ResourceLocation)loc));
        });
    }

    public void registerChestsFromWorldSave(String modID, List<String> resourceFolders) {
        for (String folder : resourceFolders) {
            List<ResourceLocation> resourceLocations = this.getLootTablesResourceLocations(modID, folder);
            resourceLocations.forEach(loc -> {
                LOGGER.debug("world save -> loading loot table shell resource loc -> {}, {}", (Object)this.getWorldDataBaseFolder().getPath(), (Object)loc.func_110623_a().toString());
                this.tableChest((ResourceLocation)loc, this.loadLootTable(this.getWorldDataBaseFolder(), (ResourceLocation)loc));
            });
        }
    }

    private void tableChest(ResourceLocation resourceLocation, Optional<LootTableShell> lootTable) {
        Treasure.LOGGER.debug("is loot table present -> {}", (Object)lootTable.isPresent());
        if (lootTable.isPresent()) {
            lootTable.get().setResourceLocation(resourceLocation);
            Path path = Paths.get(resourceLocation.func_110623_a(), new String[0]);
            Rarity key = Rarity.valueOf(path.getName(path.getNameCount() - 2).toString().toUpperCase());
            List shells = (List)this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key);
            Optional<LootTableShell> shell = shells.stream().filter(s -> s.getResourceLocation().equals((Object)resourceLocation)).findAny();
            if (shell.isPresent()) {
                LOGGER.debug("removing loot table shell from table -> {} {}", (Object)CUSTOM_LOOT_TABLE_KEY, (Object)key);
                ((List)this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).remove(shell.get());
                this.CHEST_LOOT_TABLES_MAP.remove(resourceLocation);
            }
            ((List)this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).add(lootTable.get());
            LOGGER.debug("tabling loot table: {} {} -> {}", (Object)CUSTOM_LOOT_TABLE_KEY, (Object)key, (Object)resourceLocation);
            this.CHEST_LOOT_TABLES_MAP.put(resourceLocation, lootTable.get());
            Treasure.LOGGER.debug("tables table size -> {}", (Object)((List)this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)key)).size());
            Treasure.LOGGER.debug("tables map @ {} -> {}", (Object)resourceLocation, (Object)this.CHEST_LOOT_TABLES_MAP.get(resourceLocation));
        } else {
            LOGGER.debug("unable to load loot table from -> {}", (Object)resourceLocation);
        }
    }

    public void registerSpecials(String modID, List<String> locations) {
        List<ResourceLocation> specialLocations = this.getLootTablesResourceLocations(modID, locations);
        LOGGER.debug("size of special chest loot table locations -> {}", (Object)specialLocations.size());
        specialLocations.forEach(loc -> {
            LOGGER.debug("register chests -> loading special loot table shell resource loc -> {}", (Object)loc.func_110623_a().toString());
            this.tableSpecialChest((ResourceLocation)loc, this.loadLootTable((ResourceLocation)loc));
        });
    }

    public void registerSpecialsFromWorldSave(String modID, List<String> resourceFolders) {
        for (String folder : resourceFolders) {
            List<ResourceLocation> resourceLocations = this.getLootTablesResourceLocations(modID, folder);
            resourceLocations.forEach(loc -> {
                LOGGER.debug("world save -> loading special loot table shell resource loc -> {}, {}", (Object)this.getWorldDataBaseFolder().getPath(), (Object)loc.func_110623_a().toString());
                this.tableSpecialChest((ResourceLocation)loc, this.loadLootTable(this.getWorldDataBaseFolder(), (ResourceLocation)loc));
            });
        }
    }

    private void tableSpecialChest(ResourceLocation resourceLocation, Optional<LootTableShell> lootTable) {
        if (lootTable.isPresent()) {
            lootTable.get().setResourceLocation(resourceLocation);
            Path path = Paths.get(resourceLocation.func_110623_a(), new String[0]);
            SpecialLootTables specialLootTables = SpecialLootTables.valueOf(Files.getNameWithoutExtension((String)path.getName(path.getNameCount() - 1).toString().toUpperCase()));
            LOGGER.debug("special loot tables enum -> {}", (Object)specialLootTables);
            LootTableShell shell = this.CHEST_LOOT_TABLES_MAP.get(resourceLocation);
            if (shell != null) {
                this.SPECIAL_LOOT_TABLES_MAP.remove((Object)specialLootTables);
                this.CHEST_LOOT_TABLES_MAP.remove(resourceLocation);
            }
            this.SPECIAL_LOOT_TABLES_MAP.put(specialLootTables, lootTable.get());
            LOGGER.debug("tabling special loot table: {} -> {}", (Object)specialLootTables, (Object)resourceLocation);
            this.CHEST_LOOT_TABLES_MAP.put(resourceLocation, lootTable.get());
        } else {
            LOGGER.debug("unable to load special loot table from -> {}", (Object)resourceLocation);
        }
    }

    public void registerInjects(String modID, List<String> locations) {
        List<ResourceLocation> resourceLocations = this.getLootTablesResourceLocations(modID, locations);
        resourceLocations.forEach(loc -> {
            LOGGER.debug("register injects -> loading loot table shell resource loc -> {}", (Object)loc.func_110623_a().toString());
            this.tableInject((ResourceLocation)loc, this.loadLootTable((ResourceLocation)loc));
        });
    }

    public void registerInjectsFromWorldSave(String modID, List<String> resourceFolders) {
        for (String folder : resourceFolders) {
            List<ResourceLocation> resourceLocations = this.getLootTablesResourceLocations(modID, folder);
            resourceLocations.forEach(loc -> {
                LOGGER.debug("world save -> loading inject loot table shell resource loc -> {}, {}", (Object)this.getWorldDataBaseFolder().getPath(), (Object)loc.func_110623_a().toString());
                this.tableInject((ResourceLocation)loc, this.loadLootTable(this.getWorldDataBaseFolder(), (ResourceLocation)loc));
            });
        }
    }

    private void tableInject(ResourceLocation resourceLocation, Optional<LootTableShell> lootTable) {
        if (lootTable.isPresent()) {
            lootTable.get().setResourceLocation(resourceLocation);
            Path path = Paths.get(resourceLocation.func_110623_a(), new String[0]);
            Rarity rarity = Rarity.valueOf(path.getName(path.getNameCount() - 2).toString().toUpperCase());
            List<String> keys = lootTable.get().getCategories();
            keys.forEach(key -> {
                LOGGER.debug("using inject key to table -> {}", key);
                key = key.isEmpty() ? "general" : key;
                List shells = (List)this.INJECT_LOOT_TABLES_TABLE.get(key, (Object)rarity);
                if (shells != null) {
                    Optional<LootTableShell> shell = shells.stream().filter(s -> s.getResourceLocation().equals((Object)resourceLocation)).findAny();
                    if (shell.isPresent()) {
                        ((List)this.INJECT_LOOT_TABLES_TABLE.get(key, (Object)rarity)).remove(shell.get());
                    }
                } else {
                    this.INJECT_LOOT_TABLES_TABLE.put(key, (Object)rarity, new ArrayList());
                }
                ((List)this.INJECT_LOOT_TABLES_TABLE.get(key, (Object)rarity)).add(lootTable.get());
                LOGGER.debug("tabling inject loot table: {} {} -> {}", key, (Object)rarity, (Object)resourceLocation);
            });
        } else {
            LOGGER.debug("unable to load inject loot table from -> {}", (Object)resourceLocation);
        }
    }

    public Optional<LootTableShell> loadLootTable(ResourceLocation resource) {
        Optional<LootTableShell> resourceLootTable = Optional.empty();
        String relativePath = "assets/" + resource.func_110624_b() + CUSTOM_LOOT_TABLES_RESOURCE_PATH + resource.func_110623_a() + ".json";
        Treasure.LOGGER.debug("loot table relative path -> {}", (Object)relativePath);
        try (InputStream resourceStream = Treasure.instance.getClass().getClassLoader().getResourceAsStream(relativePath);
             InputStreamReader reader = new InputStreamReader(resourceStream, StandardCharsets.UTF_8);){
            resourceLootTable = Optional.of(this.loadLootTable(reader));
        }
        catch (Exception e) {
            Treasure.LOGGER.error(String.format("Couldn't load resource loot table %s ", relativePath), (Throwable)e);
        }
        return resourceLootTable;
    }

    public LootTableShell loadLootTable(Reader reader) {
        return (LootTableShell)GSON_INSTANCE.fromJson(reader, LootTableShell.class);
    }

    public List<LootTableShell> getLootTableByRarity(Rarity rarity) {
        ArrayList<LootTableShell> tables = new ArrayList<LootTableShell>();
        Map mapOfLootTables = this.CHEST_LOOT_TABLES_TABLE.column((Object)rarity);
        Treasure.LOGGER.debug("searching for {} {} -> {}", (Object)CUSTOM_LOOT_TABLE_KEY, (Object)rarity, this.CHEST_LOOT_TABLES_TABLE.get((Object)CUSTOM_LOOT_TABLE_KEY, (Object)rarity));
        for (Map.Entry n : mapOfLootTables.entrySet()) {
            Treasure.LOGGER.debug("Adding table shell entry to loot table list -> {} {}: size {}", (Object)rarity, n.getKey(), (Object)((List)n.getValue()).size());
            tables.addAll((Collection)n.getValue());
        }
        return tables;
    }

    public Optional<LootTableShell> getLootTableByResourceLocation(ResourceLocation location) {
        LootTableShell lootTableShell = this.CHEST_LOOT_TABLES_MAP.get(location);
        return Optional.ofNullable(lootTableShell);
    }

    public List<LootTableShell> getLootTableByRarity(ManagedTableType tableType, Rarity rarity) {
        Treasure.LOGGER.debug("managed table type -> {}", (Object)tableType);
        Table<String, Rarity, List<LootTableShell>> table = tableType == ManagedTableType.CHEST ? this.CHEST_LOOT_TABLES_TABLE : this.INJECT_LOOT_TABLES_TABLE;
        ArrayList<LootTableShell> tables = new ArrayList<LootTableShell>();
        Map mapOfLootTables = table.column((Object)rarity);
        for (Map.Entry n : mapOfLootTables.entrySet()) {
            Treasure.LOGGER.debug("Adding table shell entry to loot table list -> {} {}: size {}", (Object)rarity, n.getKey(), (Object)((List)n.getValue()).size());
            tables.addAll((Collection)n.getValue());
        }
        return tables;
    }

    public List<LootTableShell> getLootTableByKeyRarity(ManagedTableType tableType, String key, Rarity rarity) {
        Table<String, Rarity, List<LootTableShell>> table = tableType == ManagedTableType.CHEST ? this.CHEST_LOOT_TABLES_TABLE : this.INJECT_LOOT_TABLES_TABLE;
        List tables = (List)table.get((Object)key, (Object)rarity);
        return tables;
    }

    public List<ResourceLocation> getLootTableResourceByRarity(Rarity rarity) {
        ArrayList<ResourceLocation> tables = new ArrayList<ResourceLocation>();
        Map mapOfLootTableResourceLocations = this.CHEST_LOOT_TABLES_RESOURCE_LOCATION_TABLE.column((Object)rarity);
        for (Map.Entry n : mapOfLootTableResourceLocations.entrySet()) {
            tables.addAll((Collection)n.getValue());
        }
        return tables;
    }

    public LootTableShell getSpecialLootTable(SpecialLootTables table) {
        Treasure.LOGGER.debug("searching for special loot table --> {}", (Object)table);
        LootTableShell lootTable = this.SPECIAL_LOOT_TABLES_MAP.get((Object)table);
        return lootTable;
    }

    public Rarity getEffectiveRarity(LootTableShell lootTableShell, Rarity defaultRarity) {
        return !StringUtils.func_151246_b((String)lootTableShell.getRarity()) ? Rarity.getByValue(lootTableShell.getRarity().toLowerCase()) : defaultRarity;
    }

    public static enum SpecialLootTables {
        WITHER_CHEST,
        SKULL_CHEST,
        GOLD_SKULL_CHEST,
        CRYSTAL_SKULL_CHEST,
        CAULDRON_CHEST,
        CLAM_CHEST,
        OYSTER_CHEST,
        SILVER_WELL,
        GOLD_WELL,
        WHITE_PEARL_WELL,
        BLACK_PEARL_WELL;


        public static List<String> getNames() {
            List<String> names = EnumSet.allOf(SpecialLootTables.class).stream().map(x -> x.name()).collect(Collectors.toList());
            return names;
        }
    }

    public static enum ManagedTableType {
        CHEST,
        INJECT;

    }
}

