/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.wish;

import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster2;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import com.someguyssoftware.treasure2.wish.IWishProvider;
import com.someguyssoftware.treasure2.wish.IWishProviderFunction;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;

public interface IWishable {
    public static final String DROPPED_BY_KEY = "droppedBy";

    default public Optional<List<LootTableShell>> buildInjectedLootTableList(String key, Rarity rarity) {
        return Optional.ofNullable(TreasureLootTableRegistry.getLootTableMaster().getLootTableByKeyRarity(TreasureLootTableMaster2.ManagedTableType.INJECT, key, rarity));
    }

    default public List<ItemStack> getLootItems(World world, Random random, List<LootTableShell> list, LootContext lootContext) {
        return TreasureLootTableRegistry.getLootTableMaster().getInjectedLootItems(world, random, list, lootContext);
    }

    default public LootContext getLootContext() {
        return TreasureLootTableRegistry.getLootTableMaster().getContext();
    }

    default public LootContext getLootContext(World world, EntityPlayer player) {
        if (player == null) {
            return this.getLootContext();
        }
        LootContext lootContext = new LootContext.Builder((WorldServer)world).func_186469_a(player.func_184817_da()).func_186470_a(player).func_186471_a();
        return lootContext;
    }

    default public Optional<IWishProvider> getWishProvider(World world, ICoords coords, List<IWishProvider> wishProviders) {
        for (IWishProvider provider : wishProviders) {
            if (!provider.isValidAt(world, coords)) continue;
            return Optional.of(provider);
        }
        return Optional.empty();
    }

    default public Optional<IWishProvider> getWishProvider(World world, ICoords coords, List<IWishProvider> wishProviders, IWishProviderFunction function) {
        return Optional.ofNullable(function.getProvider(world, coords, wishProviders));
    }
}

